/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.api.item;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.lambdaurora.lambdynlights.LambDynLights;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public abstract class ItemLightSource {
    private final ResourceLocation id;
    private final Item item;
    private final boolean waterSensitive;

    public ItemLightSource(ResourceLocation id, Item item, boolean waterSensitive) {
        this.id = id;
        this.item = item;
        this.waterSensitive = waterSensitive;
    }

    public ItemLightSource(ResourceLocation id, Item item) {
        this(id, item, false);
    }

    public ResourceLocation id() {
        return this.id;
    }

    public Item item() {
        return this.item;
    }

    public boolean waterSensitive() {
        return this.waterSensitive;
    }

    public int getLuminance(ItemStack stack, boolean submergedInWater) {
        if (this.waterSensitive() && submergedInWater) {
            return 0;
        }
        return this.getLuminance(stack);
    }

    public abstract int getLuminance(ItemStack var1);

    public String toString() {
        return "ItemLightSource{id=" + this.id() + "item=" + this.item() + ", water_sensitive=" + this.waterSensitive() + "}";
    }

    @NotNull
    public static Optional<ItemLightSource> fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
        JsonPrimitive luminanceElement;
        if (!json.has("item") || !json.has("luminance")) {
            LambDynLights.get().warn("Failed to parse item light source \"" + id + "\", invalid format: missing required fields.");
            return Optional.empty();
        }
        ResourceLocation affectId = new ResourceLocation(json.get("item").getAsString());
        Item item = (Item)Registry.f_122827_.m_7745_(affectId);
        if (item == Items.f_41852_) {
            return Optional.empty();
        }
        boolean waterSensitive = false;
        if (json.has("water_sensitive")) {
            waterSensitive = json.get("water_sensitive").getAsBoolean();
        }
        if ((luminanceElement = json.get("luminance").getAsJsonPrimitive()).isNumber()) {
            return Optional.of(new StaticItemLightSource(id, item, luminanceElement.getAsInt(), waterSensitive));
        }
        if (luminanceElement.isString()) {
            String luminanceStr = luminanceElement.getAsString();
            if (luminanceStr.equals("block")) {
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    return Optional.of(new BlockItemLightSource(id, item, blockItem.m_40614_().m_49966_(), waterSensitive));
                }
            } else {
                Block block;
                ResourceLocation blockId = ResourceLocation.m_135820_((String)luminanceStr);
                if (blockId != null && (block = (Block)Registry.f_122824_.m_7745_(blockId)) != Blocks.f_50016_) {
                    return Optional.of(new BlockItemLightSource(id, item, block.m_49966_(), waterSensitive));
                }
            }
        } else {
            LambDynLights.get().warn("Failed to parse item light source \"" + id + "\", invalid format: \"luminance\" field value isn't string or integer.");
        }
        return Optional.empty();
    }

    public static class StaticItemLightSource
    extends ItemLightSource {
        private final int luminance;

        public StaticItemLightSource(ResourceLocation id, Item item, int luminance, boolean waterSensitive) {
            super(id, item, waterSensitive);
            this.luminance = luminance;
        }

        public StaticItemLightSource(ResourceLocation id, Item item, int luminance) {
            super(id, item);
            this.luminance = luminance;
        }

        @Override
        public int getLuminance(ItemStack stack) {
            return this.luminance;
        }
    }

    public static class BlockItemLightSource
    extends ItemLightSource {
        private final BlockState mimic;

        public BlockItemLightSource(ResourceLocation id, Item item, BlockState block, boolean waterSensitive) {
            super(id, item, waterSensitive);
            this.mimic = block;
        }

        @Override
        public int getLuminance(ItemStack stack) {
            return BlockItemLightSource.getLuminance(stack, this.mimic);
        }

        static int getLuminance(ItemStack stack, BlockState state) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt != null) {
                CompoundTag blockStateTag = nbt.m_128469_("BlockStateTag");
                StateDefinition stateManager = state.m_60734_().m_49965_();
                for (String key : blockStateTag.m_128431_()) {
                    Property property = stateManager.m_61081_(key);
                    if (property == null) continue;
                    String value = blockStateTag.m_128423_(key).m_7916_();
                    state = BlockItemLightSource.with(state, property, value);
                }
            }
            return state.m_60791_();
        }

        private static <T extends Comparable<T>> BlockState with(BlockState state, Property<T> property, String name) {
            return property.m_6215_(name).map(value -> (BlockState)state.m_61124_(property, value)).orElse(state);
        }
    }
}

