/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.starfish_studios.another_furniture.block.PlanterBoxBlock;
import com.starfish_studios.another_furniture.block.entity.PlanterBoxBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlanterBoxRenderer
implements BlockEntityRenderer<PlanterBoxBlockEntity> {
    private BlockRenderDispatcher blockRenderer;

    public PlanterBoxRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderer = context.m_173584_();
    }

    public void render(PlanterBoxBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Direction facing = ((Direction)blockEntity.m_58900_().m_61143_((Property)PlanterBoxBlock.FACING)).m_122424_();
        float rotation = -facing.m_122435_();
        BlockState upper = null;
        poseStack.m_85836_();
        poseStack.m_85841_(0.7f, 0.7f, 0.7f);
        poseStack.m_85837_(0.0, (double)0.4f, 0.0);
        for (int i = 0; i < 2; ++i) {
            BlockState lower;
            Item item = blockEntity.getItemFromSlot(i);
            if (item == Items.f_41852_) continue;
            Block block = ((BlockItem)item).m_40614_();
            if (block instanceof DoublePlantBlock) {
                lower = (BlockState)block.m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER);
                upper = (BlockState)block.m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER);
            } else {
                lower = block.m_49966_();
            }
            poseStack.m_85836_();
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
            poseStack.m_85837_((double)0.6f - 0.8 * (double)i, (double)(0.001f * (float)i), (double)0.2f);
            poseStack.m_85837_(0.0, (double)(0.001f * (float)i), (double)(0.001f * (float)i));
            switch ((Direction)blockEntity.m_58900_().m_61143_((Property)PlanterBoxBlock.FACING)) {
                case EAST: {
                    poseStack.m_85837_(0.0, 0.0, (double)-1.4f);
                    break;
                }
                case WEST: {
                    poseStack.m_85837_((double)-1.4f, 0.0, 0.0);
                    break;
                }
                case SOUTH: {
                    poseStack.m_85837_((double)-1.4f, 0.0, (double)-1.4f);
                }
            }
            if (((Boolean)blockEntity.m_58900_().m_61143_((Property)PlanterBoxBlock.ATTACHED)).booleanValue()) {
                poseStack.m_85837_(0.0, (double)0.9f, (double)0.36f);
            }
            this.blockRenderer.m_110912_(lower, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
            if (upper != null) {
                poseStack.m_85837_(0.0, 1.0, 0.0);
                this.blockRenderer.m_110912_(upper, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
            }
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }
}

