/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.entity.ShelfBlockEntity;
import com.starfish_studios.another_furniture.block.properties.HorizontalConnectionType;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.util.block.BlockPart;
import com.starfish_studios.another_furniture.util.block.ShapeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShelfBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<HorizontalConnectionType> TYPE = ModBlockStateProperties.HORIZONTAL_CONNECTION_TYPE;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NL = Block.m_49796_((double)12.0, (double)6.0, (double)6.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape NR = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)4.0, (double)14.0, (double)16.0);
    protected static final VoxelShape T_NL = Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)NL);
    protected static final VoxelShape T_NR = Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)NR);
    protected static final VoxelShape T_NLR = Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{NL, NR});
    protected static final VoxelShape T_EL = ShapeUtil.rotateShape(T_NL, Direction.EAST);
    protected static final VoxelShape T_ER = ShapeUtil.rotateShape(T_NR, Direction.EAST);
    protected static final VoxelShape T_ELR = ShapeUtil.rotateShape(T_NLR, Direction.EAST);
    protected static final VoxelShape T_SL = ShapeUtil.rotateShape(T_NL, Direction.SOUTH);
    protected static final VoxelShape T_SR = ShapeUtil.rotateShape(T_NR, Direction.SOUTH);
    protected static final VoxelShape T_SLR = ShapeUtil.rotateShape(T_NLR, Direction.SOUTH);
    protected static final VoxelShape T_WL = ShapeUtil.rotateShape(T_NL, Direction.WEST);
    protected static final VoxelShape T_WR = ShapeUtil.rotateShape(T_NLR, Direction.WEST);
    protected static final VoxelShape T_WLR = ShapeUtil.rotateShape(T_NLR, Direction.WEST);

    public ShelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)HorizontalConnectionType.SINGLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hit.m_82434_() != Direction.UP) {
            return InteractionResult.PASS;
        }
        BlockEntity blockentity = level.m_7702_(pos);
        if (!(blockentity instanceof ShelfBlockEntity)) {
            return InteractionResult.PASS;
        }
        ShelfBlockEntity shelfBE = (ShelfBlockEntity)blockentity;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        int slot = BlockPart.get2D(pos, hit.m_82450_(), facing.m_122427_(), facing, 2, 2);
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_()) {
            if (!level.f_46443_ && shelfBE.placeItem(player.m_150110_().f_35937_ ? stack.m_41777_() : stack, slot)) {
                level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (shelfBE.removeItem(slot, player, level)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfBE = (ShelfBlockEntity)blockentity;
            Containers.m_19010_((Level)level, (BlockPos)pos, shelfBE.getItems());
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        HorizontalConnectionType type = (HorizontalConnectionType)((Object)state.m_61143_(TYPE));
        if (direction == Direction.NORTH) {
            return switch (type) {
                case HorizontalConnectionType.SINGLE -> T_NLR;
                case HorizontalConnectionType.LEFT -> T_NL;
                case HorizontalConnectionType.RIGHT -> T_NR;
                default -> TOP;
            };
        }
        if (direction == Direction.EAST) {
            return switch (type) {
                case HorizontalConnectionType.SINGLE -> T_ELR;
                case HorizontalConnectionType.LEFT -> T_EL;
                case HorizontalConnectionType.RIGHT -> T_ER;
                default -> TOP;
            };
        }
        if (direction == Direction.SOUTH) {
            return switch (type) {
                case HorizontalConnectionType.SINGLE -> T_SLR;
                case HorizontalConnectionType.LEFT -> T_SL;
                case HorizontalConnectionType.RIGHT -> T_SR;
                default -> TOP;
            };
        }
        return switch (type) {
            case HorizontalConnectionType.SINGLE -> T_WLR;
            case HorizontalConnectionType.LEFT -> T_WL;
            case HorizontalConnectionType.RIGHT -> T_WR;
            default -> TOP;
        };
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean waterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        boolean r_side;
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        BlockState above = level.m_8055_(currentPos.m_7494_());
        if (direction == Direction.UP && above.m_60783_((BlockGetter)level, currentPos, Direction.DOWN) && !above.m_60771_((BlockGetter)level, currentPos.m_7494_(), CollisionContext.m_82749_()).m_83281_() && (blockEntity = level.m_7702_(currentPos)) instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfBE = (ShelfBlockEntity)blockEntity;
            shelfBE.removeAllItems();
        }
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        Direction dirL = facing.m_122427_();
        Direction dirR = facing.m_122428_();
        if (direction != dirL && direction != dirR) {
            return state;
        }
        BlockState l_state = level.m_8055_(currentPos.m_121945_(dirL));
        BlockState r_state = level.m_8055_(currentPos.m_121945_(dirR));
        boolean l_side = l_state.m_60734_() instanceof ShelfBlock && l_state.m_61143_((Property)BlockStateProperties.f_61374_) == facing;
        boolean bl = r_side = r_state.m_60734_() instanceof ShelfBlock && r_state.m_61143_((Property)BlockStateProperties.f_61374_) == facing;
        HorizontalConnectionType type = l_side && r_side ? HorizontalConnectionType.MIDDLE : (r_side ? HorizontalConnectionType.LEFT : (l_side ? HorizontalConnectionType.RIGHT : HorizontalConnectionType.SINGLE));
        return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)type));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ShelfBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TYPE, WATERLOGGED});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

