/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.entity.SeatEntity;
import com.starfish_studios.another_furniture.registry.AFBlockTags;
import com.starfish_studios.another_furniture.registry.AFEntityTypeTags;
import com.starfish_studios.another_furniture.registry.AFRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class SeatBlock
extends Block {
    public SeatBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public float seatHeight(BlockState state) {
        return 0.25f;
    }

    public boolean isSittable(BlockState state) {
        return true;
    }

    public BlockPos primaryDismountLocation(Level level, BlockState state, BlockPos pos) {
        return pos;
    }

    public float setRiderRotation(BlockState state, Entity entity) {
        return entity.m_146908_();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (AFRegistry.isFakePlayer(player)) {
            return InteractionResult.PASS;
        }
        if (!level.m_7966_(player, pos)) {
            return InteractionResult.PASS;
        }
        if (!this.isSittable(state) || player.m_20159_() || player.m_6047_()) {
            return InteractionResult.PASS;
        }
        if (SeatBlock.isSeatBlocked(level, pos)) {
            return InteractionResult.PASS;
        }
        if (SeatBlock.isSeatOccupied(level, pos)) {
            List seats = level.m_45976_(SeatEntity.class, new AABB(pos));
            if (SeatBlock.ejectSeatedExceptPlayer(level, (SeatEntity)((Object)seats.get(0)))) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        SeatBlock.sitDown(level, pos, SeatBlock.getLeashed(player).orElse((Entity)player));
        return InteractionResult.SUCCESS;
    }

    public void m_5548_(BlockGetter reader, Entity entity) {
        BlockPos pos = entity.m_20183_();
        if (reader.m_8055_(pos).m_60734_() != this && reader.m_8055_(pos = pos.m_7495_()).m_60734_() != this) {
            return;
        }
        if (entity instanceof Player || !(entity instanceof LivingEntity) || !SeatBlock.canBePickedUp(entity) || SeatBlock.isSeatOccupied(entity.f_19853_, pos)) {
            super.m_5548_(reader, entity);
            return;
        }
        SeatBlock.sitDown(entity.f_19853_, pos, entity);
    }

    public static boolean isSeatBlocked(Level level, BlockPos pos) {
        return !level.m_8055_(pos.m_7494_()).m_60812_((BlockGetter)level, pos).m_83281_() && !level.m_8055_(pos.m_7494_()).m_204336_(AFBlockTags.ABOVE_BYPASSES_SEAT_CHECK);
    }

    public static boolean isSeatOccupied(Level level, BlockPos pos) {
        return !level.m_45976_(SeatEntity.class, new AABB(pos)).isEmpty();
    }

    public static Optional<Entity> getLeashed(Player player) {
        List entities = player.f_19853_.m_6249_((Entity)null, player.m_20191_().m_82400_(10.0), e -> true);
        for (Entity e2 : entities) {
            Mob mob;
            if (!(e2 instanceof Mob) || (mob = (Mob)e2).m_21524_() != player || !SeatBlock.canBePickedUp(e2)) continue;
            return Optional.of(mob);
        }
        return Optional.empty();
    }

    public static boolean ejectSeatedExceptPlayer(Level level, SeatEntity seatEntity) {
        List passengers = seatEntity.m_20197_();
        if (!passengers.isEmpty() && passengers.get(0) instanceof Player) {
            return false;
        }
        if (!level.f_46443_) {
            seatEntity.m_20153_();
        }
        return true;
    }

    public static boolean canBePickedUp(Entity passenger) {
        if (passenger instanceof Player) {
            return false;
        }
        if (passenger.m_6095_().m_204039_(AFEntityTypeTags.CANNOT_SIT_IN_SEATS)) {
            return false;
        }
        return passenger instanceof LivingEntity;
    }

    public static void sitDown(Level level, BlockPos pos, Entity entity) {
        if (level.f_46443_) {
            return;
        }
        SeatEntity seat = new SeatEntity(level, pos);
        level.m_7967_((Entity)seat);
        entity.m_20329_((Entity)seat);
        level.m_46717_(pos, level.m_8055_(pos).m_60734_());
        if (entity instanceof TamableAnimal) {
            TamableAnimal ta = (TamableAnimal)entity;
            ta.m_21837_(true);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return SeatBlock.isSeatOccupied(level, pos) ? 15 : 0;
    }
}

