/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.world.block_entity_ticking.world_border;

import me.jellysquid.mods.lithium.common.world.listeners.WorldBorderListenerOnce;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.BorderStatus;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(targets={"net.minecraft.world.chunk.WorldChunk$DirectBlockEntityTickInvoker"})
public abstract class DirectBlockEntityTickInvokerMixin
implements WorldBorderListenerOnce {
    @Shadow
    @Final
    LevelChunk f_156427_;
    private byte worldBorderState = 0;

    @Shadow
    public abstract BlockPos m_142689_();

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/WorldChunk;canTickBlockEntity(Lnet/minecraft/util/math/BlockPos;)Z"))
    private boolean cachedCanTickBlockEntity(LevelChunk instance, BlockPos pos) {
        if (this.isInsideWorldBorder()) {
            Level world = this.f_156427_.m_62953_();
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                return this.f_156427_.m_6708_().m_140114_(ChunkHolder.FullChunkStatus.TICKING) && serverWorld.m_143319_(ChunkPos.m_151388_((BlockPos)pos));
            }
            return true;
        }
        return false;
    }

    private boolean isInsideWorldBorder() {
        byte worldBorderState;
        if (this.worldBorderState == 0) {
            this.startWorldBorderCaching();
        }
        if (((worldBorderState = this.worldBorderState) & 3) == 3) {
            return (worldBorderState & 4) != 0;
        }
        return this.f_156427_.m_62953_().m_6857_().m_61937_(this.m_142689_());
    }

    private void startWorldBorderCaching() {
        boolean isStationary;
        this.worldBorderState = 1;
        WorldBorder worldBorder = this.f_156427_.m_62953_().m_6857_();
        worldBorder.m_61929_((BorderChangeListener)this);
        boolean bl = isStationary = worldBorder.m_61954_() == BorderStatus.STATIONARY;
        if (worldBorder.m_61937_(this.m_142689_())) {
            if (isStationary || worldBorder.m_61954_() == BorderStatus.GROWING) {
                this.worldBorderState = (byte)(this.worldBorderState | 6);
            }
        } else if (isStationary || worldBorder.m_61954_() == BorderStatus.SHRINKING) {
            this.worldBorderState = (byte)(this.worldBorderState | 2);
        }
    }

    @Override
    public void onWorldBorderShapeChange(WorldBorder worldBorder) {
        this.worldBorderState = 0;
    }
}

