/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.entity.data_tracker.use_arrays;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.concurrent.locks.ReadWriteLock;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={SynchedEntityData.class})
public abstract class DataTrackerMixin {
    private static final int DEFAULT_ENTRY_COUNT = 10;
    private static final int GROW_FACTOR = 8;
    @Shadow
    @Final
    private ReadWriteLock f_135346_;
    @Mutable
    @Shadow
    @Final
    private Int2ObjectMap<SynchedEntityData.DataItem<?>> f_135345_;
    private SynchedEntityData.DataItem<?>[] entriesArray = new SynchedEntityData.DataItem[10];

    @Redirect(method={"addTrackedData(Lnet/minecraft/entity/data/TrackedData;Ljava/lang/Object;)V"}, at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;put(ILjava/lang/Object;)Ljava/lang/Object;", remap=false))
    private Object onAddTrackedDataInsertMap(Int2ObjectMap<?> int2ObjectMap, int k, Object valueRaw) {
        SynchedEntityData.DataItem v = (SynchedEntityData.DataItem)valueRaw;
        SynchedEntityData.DataItem<?>[] storage = this.entriesArray;
        if (storage.length <= k) {
            int newSize = Math.min(k + 8, 256);
            this.entriesArray = storage = Arrays.copyOf(storage, newSize);
        }
        storage[k] = v;
        return this.f_135345_.put(k, (Object)v);
    }

    @Overwrite
    public <T> SynchedEntityData.DataItem<T> m_135379_(EntityDataAccessor<T> data) {
        this.f_135346_.readLock().lock();
        try {
            SynchedEntityData.DataItem<?>[] array = this.entriesArray;
            int id = data.m_135015_();
            if (id < 0 || id >= array.length) {
                SynchedEntityData.DataItem<T> dataItem = null;
                return dataItem;
            }
            SynchedEntityData.DataItem<?> dataItem = array[id];
            return dataItem;
        }
        catch (Throwable cause) {
            throw DataTrackerMixin.onGetException(cause, data);
        }
        finally {
            this.f_135346_.readLock().unlock();
        }
    }

    private static <T> ReportedException onGetException(Throwable cause, EntityDataAccessor<T> data) {
        CrashReport report = CrashReport.m_127521_((Throwable)cause, (String)"Getting synced entity data");
        CrashReportCategory section = report.m_127514_("Synced entity data");
        section.m_128159_("Data ID", data);
        return new ReportedException(report);
    }
}

