/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.block.hopper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import me.jellysquid.mods.lithium.api.inventory.LithiumInventory;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.SectionedInventoryEntityMovementTracker;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.SectionedItemEntityMovementTracker;
import me.jellysquid.mods.lithium.common.hopper.HopperCachingState;
import me.jellysquid.mods.lithium.common.hopper.HopperHelper;
import me.jellysquid.mods.lithium.common.hopper.InventoryHelper;
import me.jellysquid.mods.lithium.common.hopper.LithiumStackList;
import me.jellysquid.mods.lithium.common.hopper.RemovalCounter;
import me.jellysquid.mods.lithium.common.hopper.UpdateReceiver;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={HopperBlockEntity.class})
public abstract class HopperBlockEntityMixin
extends BlockEntity
implements Hopper,
UpdateReceiver,
LithiumInventory {
    @Shadow
    private long f_59303_;
    private long myModCountAtLastInsert;
    private long myModCountAtLastExtract;
    private long myModCountAtLastItemCollect;
    private HopperCachingState.BlockInventory insertionMode = HopperCachingState.BlockInventory.UNKNOWN;
    private HopperCachingState.BlockInventory extractionMode = HopperCachingState.BlockInventory.UNKNOWN;
    @Nullable
    private Container insertBlockInventory;
    @Nullable
    private Container extractBlockInventory;
    private int insertBlockEntityRemovedCount;
    private int extractBlockEntityRemovedCount;
    @Nullable
    private LithiumInventory insertInventory;
    @Nullable
    private LithiumInventory extractInventory;
    @Nullable
    private LithiumStackList insertStackList;
    @Nullable
    private LithiumStackList extractStackList;
    private long insertStackListModCount;
    private long extractStackListModCount;
    private SectionedItemEntityMovementTracker<ItemEntity> collectItemEntityTracker;
    private boolean collectItemEntityTrackerWasEmpty;
    private AABB[] collectItemEntityBoxes;
    private long collectItemEntityAttemptTime;
    private SectionedInventoryEntityMovementTracker<Container> extractInventoryEntityTracker;
    private AABB extractInventoryEntityBox;
    private long extractInventoryEntityFailedSearchTime;
    private SectionedInventoryEntityMovementTracker<Container> insertInventoryEntityTracker;
    private AABB insertInventoryEntityBox;
    private long insertInventoryEntityFailedSearchTime;

    public HopperBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Shadow
    @Nullable
    private static native Container m_155596_(Level var0, Hopper var1);

    @Shadow
    private static native boolean ejectItems(Level var0, BlockPos var1, BlockState var2, HopperBlockEntity var3);

    @Shadow
    protected abstract boolean m_59409_();

    @Shadow
    private static native boolean m_59380_(Container var0, ItemStack var1, int var2, Direction var3);

    @Redirect(method={"extract(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;getInputInventory(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Lnet/minecraft/inventory/Inventory;"))
    private static Container getExtractInventory(Level world, Hopper hopper) {
        if (!(hopper instanceof HopperBlockEntityMixin)) {
            return HopperBlockEntityMixin.m_155596_(world, hopper);
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)hopper;
        Container blockInventory = hopperBlockEntity.getExtractBlockInventory(world);
        if (blockInventory != null) {
            return blockInventory;
        }
        if (hopperBlockEntity.extractInventoryEntityTracker == null) {
            hopperBlockEntity.initExtractInventoryTracker(world);
        }
        if (hopperBlockEntity.extractInventoryEntityTracker.isUnchangedSince(hopperBlockEntity.extractInventoryEntityFailedSearchTime)) {
            return null;
        }
        hopperBlockEntity.extractInventoryEntityFailedSearchTime = Long.MIN_VALUE;
        List<Container> inventoryEntities = hopperBlockEntity.extractInventoryEntityTracker.getEntities(hopperBlockEntity.extractInventoryEntityBox);
        if (inventoryEntities.isEmpty()) {
            hopperBlockEntity.extractInventoryEntityFailedSearchTime = hopperBlockEntity.f_59303_;
            return null;
        }
        Container inventory = inventoryEntities.get(world.f_46441_.m_188503_(inventoryEntities.size()));
        if (inventory instanceof LithiumInventory) {
            LithiumInventory optimizedInventory = (LithiumInventory)inventory;
            LithiumStackList extractInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
            if (inventory != hopperBlockEntity.extractInventory || hopperBlockEntity.extractStackList != extractInventoryStackList) {
                hopperBlockEntity.extractInventory = optimizedInventory;
                hopperBlockEntity.extractStackList = extractInventoryStackList;
                hopperBlockEntity.extractStackListModCount = hopperBlockEntity.extractStackList.getModCount() - 1L;
            }
        }
        return inventory;
    }

    @Redirect(method={"insertAndExtract(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;ejectItems(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/entity/HopperBlockEntity;)Z"))
    private static boolean lithiumInsert(Level world, BlockPos pos, BlockState hopperState, HopperBlockEntity blockEntity, Level world2, BlockPos pos2, BlockState state2, HopperBlockEntity blockentity2, BooleanSupplier booleanSupplier) {
        boolean insertInventoryWasEmptyHopperNotDisabled;
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)HopperBlockEntity.m_59390_((Level)world, (BlockPos)pos);
        Container insertInventory = hopperBlockEntity.getInsertInventory(world, hopperState);
        if (insertInventory == null) {
            return HopperBlockEntityMixin.ejectItems(world, pos, hopperState, blockEntity);
        }
        LithiumStackList hopperStackList = InventoryHelper.getLithiumStackList(hopperBlockEntity);
        if (hopperBlockEntity.insertInventory == insertInventory && hopperStackList.getModCount() == hopperBlockEntity.myModCountAtLastInsert && hopperBlockEntity.insertStackList.getModCount() == hopperBlockEntity.insertStackListModCount) {
            return false;
        }
        boolean bl = insertInventoryWasEmptyHopperNotDisabled = insertInventory instanceof HopperBlockEntityMixin && !((HopperBlockEntityMixin)insertInventory).m_59409_() && hopperBlockEntity.insertStackList.getOccupiedSlots() == 0;
        if (hopperBlockEntity.insertInventory != insertInventory || hopperBlockEntity.insertStackList.getFullSlots() != hopperBlockEntity.insertStackList.size()) {
            Direction fromDirection = ((Direction)hopperState.m_61143_((Property)HopperBlock.f_54021_)).m_122424_();
            int size = hopperStackList.size();
            for (int i = 0; i < size; ++i) {
                boolean transferSuccess;
                ItemStack transferStack = (ItemStack)hopperStackList.get(i);
                if (transferStack.m_41619_() || !(transferSuccess = HopperHelper.tryMoveSingleItem(insertInventory, transferStack, fromDirection))) continue;
                if (insertInventoryWasEmptyHopperNotDisabled) {
                    HopperBlockEntityMixin receivingHopper = (HopperBlockEntityMixin)insertInventory;
                    int k = 8;
                    if (receivingHopper.f_59303_ >= hopperBlockEntity.f_59303_) {
                        k = 7;
                    }
                    receivingHopper.m_59395_(k);
                }
                insertInventory.m_6596_();
                return true;
            }
        }
        hopperBlockEntity.myModCountAtLastInsert = hopperStackList.getModCount();
        if (hopperBlockEntity.insertStackList != null) {
            hopperBlockEntity.insertStackListModCount = hopperBlockEntity.insertStackList.getModCount();
        }
        return false;
    }

    @Inject(method={"extract(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Z"}, at={@At(value="FIELD", target="Lnet/minecraft/util/math/Direction;DOWN:Lnet/minecraft/util/math/Direction;", shift=At.Shift.AFTER)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void lithiumExtract(Level world, Hopper to, CallbackInfoReturnable<Boolean> cir) {
        Container from = HopperBlockEntityMixin.m_155596_(world, to);
        if (!(to instanceof HopperBlockEntityMixin)) {
            return;
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)to;
        if (from != hopperBlockEntity.extractInventory) {
            return;
        }
        LithiumStackList hopperStackList = InventoryHelper.getLithiumStackList(hopperBlockEntity);
        LithiumStackList fromStackList = hopperBlockEntity.extractStackList;
        if (hopperStackList.getModCount() == hopperBlockEntity.myModCountAtLastExtract && fromStackList.getModCount() == hopperBlockEntity.extractStackListModCount) {
            fromStackList.runComparatorUpdatePatternOnFailedExtract(fromStackList, from);
            cir.setReturnValue((Object)false);
            return;
        }
        int[] availableSlots = from instanceof WorldlyContainer ? ((WorldlyContainer)from).m_7071_(Direction.DOWN) : null;
        int fromSize = availableSlots != null ? availableSlots.length : from.m_6643_();
        for (int i = 0; i < fromSize; ++i) {
            int fromSlot = availableSlots != null ? availableSlots[i] : i;
            ItemStack itemStack = (ItemStack)fromStackList.get(fromSlot);
            if (itemStack.m_41619_() || !HopperBlockEntityMixin.m_59380_(from, itemStack, fromSlot, Direction.DOWN)) continue;
            ItemStack takenItem = from.m_7407_(fromSlot, 1);
            assert (!takenItem.m_41619_());
            boolean transferSuccess = HopperHelper.tryMoveSingleItem((Container)to, takenItem, null);
            if (transferSuccess) {
                to.m_6596_();
                from.m_6596_();
                cir.setReturnValue((Object)true);
                return;
            }
            ItemStack restoredStack = (ItemStack)fromStackList.get(fromSlot);
            if (restoredStack.m_41619_()) {
                restoredStack = takenItem;
            } else {
                restoredStack.m_41769_(1);
            }
            from.m_6836_(fromSlot, restoredStack);
        }
        hopperBlockEntity.myModCountAtLastExtract = hopperStackList.getModCount();
        if (fromStackList != null) {
            hopperBlockEntity.extractStackListModCount = fromStackList.getModCount();
        }
        cir.setReturnValue((Object)false);
    }

    @Redirect(method={"insertAndExtract(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;isFull()Z"))
    private static boolean lithiumHopperIsFull(HopperBlockEntity hopperBlockEntity) {
        LithiumStackList lithiumStackList = InventoryHelper.getLithiumStackList((HopperBlockEntityMixin)hopperBlockEntity);
        return lithiumStackList.getFullSlots() == lithiumStackList.size();
    }

    @Redirect(method={"insertAndExtract(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/entity/HopperBlockEntity;Ljava/util/function/BooleanSupplier;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;isEmpty()Z"))
    private static boolean lithiumHopperIsEmpty(HopperBlockEntity hopperBlockEntity) {
        LithiumStackList lithiumStackList = InventoryHelper.getLithiumStackList((HopperBlockEntityMixin)hopperBlockEntity);
        return lithiumStackList.getOccupiedSlots() == 0;
    }

    @Shadow
    protected abstract void m_59395_(int var1);

    @Override
    public void onNeighborUpdate(boolean above) {
        if (above) {
            if (this.extractionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.extractionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
                this.invalidateBlockExtractionData();
            }
        } else if (this.insertionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY || this.insertionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
            this.invalidateBlockInsertionData();
        }
    }

    @Redirect(method={"ejectItems(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/entity/HopperBlockEntity;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;getOutputInventory(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)Lnet/minecraft/inventory/Inventory;"))
    private static Container nullify(Level world, BlockPos pos, BlockState state) {
        return null;
    }

    @Redirect(method={"extract(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/entity/HopperBlockEntity;getInputItemEntities(Lnet/minecraft/world/World;Lnet/minecraft/block/entity/Hopper;)Ljava/util/List;"))
    private static List<ItemEntity> lithiumGetInputItemEntities(Level world, Hopper hopper) {
        if (!(hopper instanceof HopperBlockEntityMixin)) {
            return HopperBlockEntity.m_155589_((Level)world, (Hopper)hopper);
        }
        HopperBlockEntityMixin hopperBlockEntity = (HopperBlockEntityMixin)hopper;
        if (hopperBlockEntity.collectItemEntityTracker == null) {
            hopperBlockEntity.initCollectItemEntityTracker();
        }
        long modCount = InventoryHelper.getLithiumStackList(hopperBlockEntity).getModCount();
        if ((hopperBlockEntity.collectItemEntityTrackerWasEmpty || hopperBlockEntity.myModCountAtLastItemCollect == modCount) && hopperBlockEntity.collectItemEntityTracker.isUnchangedSince(hopperBlockEntity.collectItemEntityAttemptTime)) {
            return Collections.emptyList();
        }
        hopperBlockEntity.myModCountAtLastItemCollect = modCount;
        List<ItemEntity> itemEntities = hopperBlockEntity.collectItemEntityTracker.getEntities(hopperBlockEntity.collectItemEntityBoxes);
        hopperBlockEntity.collectItemEntityAttemptTime = hopperBlockEntity.f_59303_;
        hopperBlockEntity.collectItemEntityTrackerWasEmpty = itemEntities.isEmpty();
        return itemEntities;
    }

    private void cacheInsertBlockInventory(Container insertInventory) {
        assert (!(insertInventory instanceof Entity));
        if (insertInventory instanceof BlockEntity || insertInventory instanceof CompoundContainer) {
            this.insertBlockInventory = insertInventory;
            this.insertionMode = HopperCachingState.BlockInventory.BLOCK_ENTITY;
        } else if (insertInventory == null) {
            this.insertBlockInventory = null;
            this.insertionMode = HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY;
        } else {
            this.insertBlockInventory = insertInventory;
            this.insertionMode = HopperCachingState.BlockInventory.BLOCK_STATE;
        }
        if (insertInventory instanceof LithiumInventory) {
            LithiumInventory optimizedInventory = (LithiumInventory)insertInventory;
            this.cacheInsertLithiumInventory(optimizedInventory);
        } else {
            this.insertInventory = null;
            this.insertStackList = null;
            this.insertStackListModCount = 0L;
            this.insertBlockEntityRemovedCount = this.insertionMode == HopperCachingState.BlockInventory.BLOCK_ENTITY ? ((RemovalCounter)insertInventory).getRemovedCountLithium() : 0;
        }
    }

    private void cacheInsertLithiumInventory(LithiumInventory optimizedInventory) {
        LithiumStackList insertInventoryStackList;
        this.insertInventory = optimizedInventory;
        this.insertStackList = insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
        this.insertStackListModCount = insertInventoryStackList.getModCount() - 1L;
        this.insertBlockEntityRemovedCount = optimizedInventory.getRemovedCountLithium();
    }

    @Overwrite
    private static boolean m_59397_(Container inv, Direction side) {
        int[] availableSlots = inv instanceof WorldlyContainer ? ((WorldlyContainer)inv).m_7071_(side) : null;
        int fromSize = availableSlots != null ? availableSlots.length : inv.m_6643_();
        for (int i = 0; i < fromSize; ++i) {
            int slot;
            int n = slot = availableSlots != null ? availableSlots[i] : i;
            if (inv.m_8020_(slot).m_41619_()) continue;
            return false;
        }
        return true;
    }

    private void cacheExtractBlockInventory(Container extractInventory) {
        assert (!(extractInventory instanceof Entity));
        if (extractInventory instanceof BlockEntity || extractInventory instanceof CompoundContainer) {
            this.extractBlockInventory = extractInventory;
            this.extractionMode = HopperCachingState.BlockInventory.BLOCK_ENTITY;
        } else if (extractInventory == null) {
            this.extractBlockInventory = null;
            this.extractionMode = HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY;
        } else {
            this.extractBlockInventory = extractInventory;
            this.extractionMode = HopperCachingState.BlockInventory.BLOCK_STATE;
        }
        if (extractInventory instanceof LithiumInventory) {
            LithiumStackList extractInventoryStackList;
            LithiumInventory optimizedInventory;
            this.extractInventory = optimizedInventory = (LithiumInventory)extractInventory;
            this.extractStackList = extractInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
            this.extractStackListModCount = extractInventoryStackList.getModCount() - 1L;
            this.extractBlockEntityRemovedCount = optimizedInventory.getRemovedCountLithium();
        } else {
            this.extractInventory = null;
            this.extractStackList = null;
            this.extractStackListModCount = 0L;
            this.extractBlockEntityRemovedCount = this.extractionMode == HopperCachingState.BlockInventory.BLOCK_ENTITY ? ((RemovalCounter)extractInventory).getRemovedCountLithium() : 0;
        }
    }

    public Container getExtractBlockInventory(Level world) {
        Container blockInventory = this.extractBlockInventory;
        if (this.extractionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY) {
            return null;
        }
        if (this.extractionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
            return blockInventory;
        }
        if (this.extractionMode == HopperCachingState.BlockInventory.BLOCK_ENTITY && ((RemovalCounter)blockInventory).getRemovedCountLithium() == this.extractBlockEntityRemovedCount) {
            LithiumInventory optimizedInventory = this.extractInventory;
            if (optimizedInventory != null) {
                LithiumStackList insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
                if (insertInventoryStackList == this.extractStackList) {
                    return optimizedInventory;
                }
                this.invalidateBlockExtractionData();
            } else {
                return blockInventory;
            }
        }
        blockInventory = HopperHelper.vanillaGetBlockInventory(world, this.m_58899_().m_7494_());
        this.cacheExtractBlockInventory(blockInventory);
        return blockInventory;
    }

    public Container getInsertBlockInventory(Level world, BlockState hopperState) {
        Container blockInventory = this.insertBlockInventory;
        if (this.insertionMode == HopperCachingState.BlockInventory.NO_BLOCK_INVENTORY) {
            return null;
        }
        if (this.insertionMode == HopperCachingState.BlockInventory.BLOCK_STATE) {
            return blockInventory;
        }
        if (this.insertionMode == HopperCachingState.BlockInventory.BLOCK_ENTITY && ((RemovalCounter)blockInventory).getRemovedCountLithium() == this.insertBlockEntityRemovedCount) {
            LithiumInventory optimizedInventory = this.insertInventory;
            if (optimizedInventory != null) {
                LithiumStackList insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
                if (insertInventoryStackList == this.insertStackList) {
                    return optimizedInventory;
                }
                this.invalidateBlockInsertionData();
            } else {
                return blockInventory;
            }
        }
        Direction direction = (Direction)hopperState.m_61143_((Property)HopperBlock.f_54021_);
        blockInventory = HopperHelper.vanillaGetBlockInventory(world, this.m_58899_().m_121945_(direction));
        this.cacheInsertBlockInventory(blockInventory);
        return blockInventory;
    }

    public Container getInsertInventory(Level world, BlockState hopperState) {
        Container blockInventory = this.getInsertBlockInventory(world, hopperState);
        if (blockInventory != null) {
            return blockInventory;
        }
        if (this.insertInventoryEntityTracker == null) {
            this.initInsertInventoryTracker(world, hopperState);
        }
        if (this.insertInventoryEntityTracker.isUnchangedSince(this.insertInventoryEntityFailedSearchTime)) {
            return null;
        }
        this.insertInventoryEntityFailedSearchTime = Long.MIN_VALUE;
        List<Container> inventoryEntities = this.insertInventoryEntityTracker.getEntities(this.insertInventoryEntityBox);
        if (inventoryEntities.isEmpty()) {
            this.insertInventoryEntityFailedSearchTime = this.f_59303_;
            return null;
        }
        Container inventory = inventoryEntities.get(world.f_46441_.m_188503_(inventoryEntities.size()));
        if (inventory instanceof LithiumInventory) {
            LithiumInventory optimizedInventory = (LithiumInventory)inventory;
            LithiumStackList insertInventoryStackList = InventoryHelper.getLithiumStackList(optimizedInventory);
            if (inventory != this.insertInventory || this.insertStackList != insertInventoryStackList) {
                this.cacheInsertLithiumInventory(optimizedInventory);
            }
        }
        return inventory;
    }

    private void initCollectItemEntityTracker() {
        assert (this.f_58857_ instanceof ServerLevel);
        ArrayList<AABB> list = new ArrayList<AABB>();
        AABB encompassingBox = null;
        for (AABB box : HopperHelper.getHopperPickupVolumeBoxes(this)) {
            AABB offsetBox = box.m_82386_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_());
            list.add(offsetBox);
            encompassingBox = encompassingBox == null ? offsetBox : encompassingBox.m_82367_(offsetBox);
        }
        list.add(encompassingBox);
        this.collectItemEntityBoxes = list.toArray(new AABB[0]);
        this.collectItemEntityTracker = SectionedItemEntityMovementTracker.registerAt((ServerLevel)this.f_58857_, encompassingBox, ItemEntity.class);
        this.collectItemEntityAttemptTime = Long.MIN_VALUE;
    }

    private void initExtractInventoryTracker(Level world) {
        assert (world instanceof ServerLevel);
        BlockPos pos = this.f_58858_.m_121945_(Direction.UP);
        this.extractInventoryEntityBox = new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1));
        this.extractInventoryEntityTracker = SectionedInventoryEntityMovementTracker.registerAt((ServerLevel)this.f_58857_, this.extractInventoryEntityBox, Container.class);
        this.extractInventoryEntityFailedSearchTime = Long.MIN_VALUE;
    }

    private void initInsertInventoryTracker(Level world, BlockState hopperState) {
        assert (world instanceof ServerLevel);
        Direction direction = (Direction)hopperState.m_61143_((Property)HopperBlock.f_54021_);
        BlockPos pos = this.f_58858_.m_121945_(direction);
        this.insertInventoryEntityBox = new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1));
        this.insertInventoryEntityTracker = SectionedInventoryEntityMovementTracker.registerAt((ServerLevel)this.f_58857_, this.insertInventoryEntityBox, Container.class);
        this.insertInventoryEntityFailedSearchTime = Long.MIN_VALUE;
    }

    public void m_155250_(BlockState state) {
        BlockState cachedState = this.m_58900_();
        super.m_155250_(state);
        if (state.m_61143_((Property)HopperBlock.f_54021_) != cachedState.m_61143_((Property)HopperBlock.f_54021_)) {
            this.invalidateCachedData();
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.invalidateCachedData();
    }

    private void invalidateCachedData() {
        this.invalidateInsertionData();
        this.invalidateExtractionData();
    }

    private void invalidateInsertionData() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.insertInventoryEntityTracker != null) {
                this.insertInventoryEntityTracker.unRegister(serverWorld);
                this.insertInventoryEntityTracker = null;
                this.insertInventoryEntityBox = null;
                this.insertInventoryEntityFailedSearchTime = 0L;
            }
        }
        this.invalidateBlockInsertionData();
    }

    private void invalidateBlockInsertionData() {
        this.insertionMode = HopperCachingState.BlockInventory.UNKNOWN;
        this.insertBlockInventory = null;
        this.insertInventory = null;
        this.insertBlockEntityRemovedCount = 0;
        this.insertStackList = null;
        this.insertStackListModCount = 0L;
    }

    private void invalidateExtractionData() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.extractInventoryEntityTracker != null) {
                this.extractInventoryEntityTracker.unRegister(serverWorld);
                this.extractInventoryEntityTracker = null;
                this.extractInventoryEntityBox = null;
                this.extractInventoryEntityFailedSearchTime = 0L;
            }
            if (this.collectItemEntityTracker != null) {
                this.collectItemEntityTracker.unRegister(serverWorld);
                this.collectItemEntityTracker = null;
                this.collectItemEntityBoxes = null;
                this.collectItemEntityTrackerWasEmpty = false;
            }
        }
        this.invalidateBlockExtractionData();
    }

    private void invalidateBlockExtractionData() {
        this.extractionMode = HopperCachingState.BlockInventory.UNKNOWN;
        this.extractBlockInventory = null;
        this.extractInventory = null;
        this.extractBlockEntityRemovedCount = 0;
        this.extractStackList = null;
        this.extractStackListModCount = 0L;
    }
}

