/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.ai.nearby_entity_tracking;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import me.jellysquid.mods.lithium.common.entity.tracker.EntityTrackerEngine;
import me.jellysquid.mods.lithium.common.entity.tracker.EntityTrackerSection;
import me.jellysquid.mods.lithium.common.entity.tracker.PositionedEntityTrackingSection;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.NearbyEntityListener;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.SectionedEntityMovementTracker;
import net.minecraft.util.ClassInstanceMultiMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.Visibility;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntitySection.class})
public abstract class EntityTrackingSectionMixin<T extends EntityAccess>
implements EntityTrackerSection,
PositionedEntityTrackingSection {
    @Shadow
    private Visibility f_156828_;
    @Shadow
    @Final
    private ClassInstanceMultiMap<T> f_156827_;
    private final ReferenceOpenHashSet<NearbyEntityListener> nearbyEntityListeners = new ReferenceOpenHashSet(0);
    private final ReferenceOpenHashSet<SectionedEntityMovementTracker<?, ?>> sectionVisibilityListeners = new ReferenceOpenHashSet(0);
    private final long[] lastEntityMovementByType = new long[EntityTrackerEngine.NUM_MOVEMENT_NOTIFYING_CLASSES];

    @Shadow
    public abstract boolean m_156833_();

    @Override
    public void addListener(NearbyEntityListener listener) {
        this.nearbyEntityListeners.add((Object)listener);
        if (this.f_156828_.m_157694_()) {
            listener.onSectionEnteredRange(this, this.f_156827_);
        }
    }

    @Override
    public void removeListener(EntitySectionStorage<?> sectionedEntityCache, NearbyEntityListener listener) {
        boolean removed = this.nearbyEntityListeners.remove((Object)listener);
        if (this.f_156828_.m_157694_() && removed) {
            listener.onSectionLeftRange(this, this.f_156827_);
        }
        if (this.m_156833_()) {
            sectionedEntityCache.m_156897_(this.getPos());
        }
    }

    @Override
    public void addListener(SectionedEntityMovementTracker<?, ?> listener) {
        this.sectionVisibilityListeners.add(listener);
        if (this.f_156828_.m_157694_()) {
            listener.onSectionEnteredRange(this);
        }
    }

    @Override
    public void removeListener(EntitySectionStorage<?> sectionedEntityCache, SectionedEntityMovementTracker<?, ?> listener) {
        boolean removed = this.sectionVisibilityListeners.remove(listener);
        if (this.f_156828_.m_157694_() && removed) {
            listener.onSectionLeftRange(this);
        }
        if (this.m_156833_()) {
            sectionedEntityCache.m_156897_(this.getPos());
        }
    }

    @Override
    public void updateMovementTimestamps(int notificationMask, long time) {
        long[] lastEntityMovementByType = this.lastEntityMovementByType;
        int size = lastEntityMovementByType.length;
        int i = Integer.numberOfTrailingZeros(notificationMask);
        while (i < size) {
            lastEntityMovementByType[i] = time;
            int mask = -2 << i;
            i = Integer.numberOfTrailingZeros(notificationMask & mask);
        }
    }

    @Override
    public long[] getMovementTimestampArray() {
        return this.lastEntityMovementByType;
    }

    @Inject(method={"isEmpty()Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void isEmpty(CallbackInfoReturnable<Boolean> cir) {
        if (!this.nearbyEntityListeners.isEmpty() || !this.sectionVisibilityListeners.isEmpty()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"add(Lnet/minecraft/world/entity/EntityLike;)V"}, at={@At(value="RETURN")})
    private void onEntityAdded(T entityLike, CallbackInfo ci) {
        if (!this.f_156828_.m_157694_() || this.nearbyEntityListeners.isEmpty()) {
            return;
        }
        if (entityLike instanceof Entity) {
            Entity entity = (Entity)entityLike;
            for (NearbyEntityListener nearbyEntityListener : this.nearbyEntityListeners) {
                nearbyEntityListener.onEntityEnteredRange(entity);
            }
        }
    }

    @ModifyVariable(method={"remove(Lnet/minecraft/world/entity/EntityLike;)Z"}, at=@At(value="RETURN"), argsOnly=true)
    private T onEntityRemoved(T entityLike) {
        if (this.f_156828_.m_157694_() && !this.nearbyEntityListeners.isEmpty() && entityLike instanceof Entity) {
            Entity entity = (Entity)entityLike;
            for (NearbyEntityListener nearbyEntityListener : this.nearbyEntityListeners) {
                nearbyEntityListener.onEntityLeftRange(entity);
            }
        }
        return entityLike;
    }

    @ModifyVariable(method={"swapStatus(Lnet/minecraft/world/entity/EntityTrackingStatus;)Lnet/minecraft/world/entity/EntityTrackingStatus;"}, at=@At(value="HEAD"), argsOnly=true)
    public Visibility swapStatus(Visibility newStatus) {
        block7: {
            block8: {
                if (this.f_156828_.m_157694_() == newStatus.m_157694_()) break block7;
                if (newStatus.m_157694_()) break block8;
                if (!this.nearbyEntityListeners.isEmpty()) {
                    for (NearbyEntityListener nearbyEntityListener : this.nearbyEntityListeners) {
                        nearbyEntityListener.onSectionLeftRange(this, this.f_156827_);
                    }
                }
                if (this.sectionVisibilityListeners.isEmpty()) break block7;
                for (SectionedEntityMovementTracker listener : this.sectionVisibilityListeners) {
                    listener.onSectionLeftRange(this);
                }
                break block7;
            }
            if (!this.nearbyEntityListeners.isEmpty()) {
                for (NearbyEntityListener nearbyEntityListener : this.nearbyEntityListeners) {
                    nearbyEntityListener.onSectionEnteredRange(this, this.f_156827_);
                }
            }
            if (!this.sectionVisibilityListeners.isEmpty()) {
                for (SectionedEntityMovementTracker listener : this.sectionVisibilityListeners) {
                    listener.onSectionEnteredRange(this);
                }
            }
        }
        return newStatus;
    }
}

