/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.world.scheduler;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.world.ticks.ScheduledTick;

public class OrderedTickQueue<T>
extends AbstractQueue<ScheduledTick<T>> {
    private static final int INITIAL_CAPACITY = 16;
    private static final Comparator<ScheduledTick<?>> COMPARATOR = Comparator.comparingLong(ScheduledTick::f_193380_);
    private ScheduledTick<T>[] arr;
    private int lastIndexExclusive;
    private int firstIndex;
    private long currentMaxSubTickOrder = Long.MIN_VALUE;
    private boolean isSorted;
    private ScheduledTick<T> unsortedPeekResult;

    public OrderedTickQueue(int capacity) {
        this.arr = new ScheduledTick[capacity];
        this.lastIndexExclusive = 0;
        this.isSorted = true;
        this.unsortedPeekResult = null;
        this.firstIndex = 0;
    }

    public OrderedTickQueue() {
        this(16);
    }

    @Override
    public void clear() {
        Arrays.fill(this.arr, null);
        this.lastIndexExclusive = 0;
        this.firstIndex = 0;
        this.currentMaxSubTickOrder = Long.MIN_VALUE;
        this.isSorted = true;
        this.unsortedPeekResult = null;
    }

    @Override
    public Iterator<ScheduledTick<T>> iterator() {
        if (this.isEmpty()) {
            return Collections.emptyIterator();
        }
        this.sort();
        return new Iterator<ScheduledTick<T>>(){
            int nextIndex;
            {
                this.nextIndex = OrderedTickQueue.this.firstIndex;
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex < OrderedTickQueue.this.lastIndexExclusive;
            }

            @Override
            public ScheduledTick<T> next() {
                return OrderedTickQueue.this.arr[this.nextIndex++];
            }
        };
    }

    @Override
    public ScheduledTick<T> poll() {
        if (this.isEmpty()) {
            return null;
        }
        if (!this.isSorted) {
            this.sort();
        }
        int polledIndex = this.firstIndex++;
        ScheduledTick<T>[] ticks = this.arr;
        ScheduledTick<T> nextTick = ticks[polledIndex];
        ticks[polledIndex] = null;
        return nextTick;
    }

    @Override
    public ScheduledTick<T> peek() {
        if (!this.isSorted) {
            return this.unsortedPeekResult;
        }
        if (this.lastIndexExclusive > this.firstIndex) {
            return this.getTickAtIndex(this.firstIndex);
        }
        return null;
    }

    @Override
    public boolean offer(ScheduledTick<T> tick) {
        if (this.lastIndexExclusive >= this.arr.length) {
            this.arr = OrderedTickQueue.copyArray(this.arr, HashCommon.nextPowerOfTwo((int)(this.arr.length + 1)));
        }
        if (tick.f_193380_() <= this.currentMaxSubTickOrder) {
            this.isSorted = false;
            ScheduledTick<T> firstTick = this.size() > 0 ? this.arr[this.firstIndex] : null;
            this.unsortedPeekResult = firstTick == null || tick.f_193380_() < firstTick.f_193380_() ? tick : firstTick;
        } else {
            this.currentMaxSubTickOrder = tick.f_193380_();
        }
        this.arr[this.lastIndexExclusive++] = tick;
        return true;
    }

    @Override
    public int size() {
        return this.lastIndexExclusive - this.firstIndex;
    }

    private void resize(int size) {
        ScheduledTick<T> tick;
        if (size == 0 || size < this.arr.length / 2) {
            this.arr = OrderedTickQueue.copyArray(this.arr, size);
        } else {
            for (int i = size; i < this.arr.length; ++i) {
                this.arr[i] = null;
            }
        }
        this.firstIndex = 0;
        this.lastIndexExclusive = size;
        this.currentMaxSubTickOrder = size == 0 || !this.isSorted ? Long.MIN_VALUE : ((tick = this.arr[size - 1]) == null ? Long.MIN_VALUE : tick.f_193380_());
    }

    public void sort() {
        if (this.isSorted) {
            return;
        }
        this.removeNullsAndConsumed();
        Arrays.sort(this.arr, this.firstIndex, this.lastIndexExclusive, COMPARATOR);
        this.isSorted = true;
        this.unsortedPeekResult = null;
    }

    public void removeNullsAndConsumed() {
        int dst = 0;
        for (int src = this.firstIndex; src < this.lastIndexExclusive; ++src) {
            ScheduledTick<T> orderedTick = this.arr[src];
            if (orderedTick == null) continue;
            this.arr[dst] = orderedTick;
            ++dst;
        }
        this.resize(dst);
    }

    public ScheduledTick<T> getTickAtIndex(int index) {
        if (!this.isSorted) {
            throw new IllegalStateException("Unexpected access on unsorted queue!");
        }
        return this.arr[index];
    }

    public void setTickAtIndex(int index, ScheduledTick<T> tick) {
        if (!this.isSorted) {
            throw new IllegalStateException("Unexpected access on unsorted queue!");
        }
        this.arr[index] = tick;
    }

    private static <T> ScheduledTick<T>[] copyArray(ScheduledTick<T>[] src, int size) {
        ScheduledTick[] copy = new ScheduledTick[size];
        if (size != 0) {
            System.arraycopy(src, 0, copy, 0, Math.min(src.length, size));
        }
        return copy;
    }

    @Override
    public boolean isEmpty() {
        return this.lastIndexExclusive <= this.firstIndex;
    }
}

