/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.tracker.nearby;

import java.util.ArrayList;
import java.util.List;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.NearbyEntityListener;
import me.jellysquid.mods.lithium.common.util.tuples.Range6Int;
import net.minecraft.world.entity.Entity;

public class NearbyEntityListenerMulti
implements NearbyEntityListener {
    private final List<NearbyEntityListener> listeners = new ArrayList<NearbyEntityListener>(4);
    private Range6Int range = null;

    public void addListener(NearbyEntityListener listener) {
        if (this.range != null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeListener(NearbyEntityListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Range6Int getChunkRange() {
        if (this.range != null) {
            return this.range;
        }
        return this.calculateRange();
    }

    private Range6Int calculateRange() {
        if (this.listeners.isEmpty()) {
            this.range = EMPTY_RANGE;
            return this.range;
        }
        int positiveX = -1;
        int positiveY = -1;
        int positiveZ = -1;
        int negativeX = 0;
        int negativeY = 0;
        int negativeZ = 0;
        for (NearbyEntityListener listener : this.listeners) {
            Range6Int chunkRange = listener.getChunkRange();
            positiveX = Math.max(chunkRange.positiveX(), positiveX);
            positiveY = Math.max(chunkRange.positiveY(), positiveY);
            positiveZ = Math.max(chunkRange.positiveZ(), positiveZ);
            negativeX = Math.max(chunkRange.negativeX(), negativeX);
            negativeY = Math.max(chunkRange.negativeY(), negativeY);
            negativeZ = Math.max(chunkRange.negativeZ(), negativeZ);
        }
        this.range = new Range6Int(positiveX, positiveY, positiveZ, negativeX, negativeY, negativeZ);
        return this.range;
    }

    @Override
    public void onEntityEnteredRange(Entity entity) {
        for (NearbyEntityListener listener : this.listeners) {
            listener.onEntityEnteredRange(entity);
        }
    }

    @Override
    public void onEntityLeftRange(Entity entity) {
        for (NearbyEntityListener listener : this.listeners) {
            listener.onEntityLeftRange(entity);
        }
    }

    public String toString() {
        StringBuilder sublisteners = new StringBuilder();
        String comma = "";
        for (NearbyEntityListener listener : this.listeners) {
            sublisteners.append(comma).append(listener.toString());
            comma = ",";
        }
        return super.toString() + " with sublisteners: [" + sublisteners + "]";
    }
}

