/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import me.jellysquid.mods.lithium.common.entity.movement.ChunkAwareBlockCollisionSweeper;
import me.jellysquid.mods.lithium.common.world.WorldHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class LithiumEntityCollisions {
    public static final double EPSILON = 1.0E-7;

    public static List<VoxelShape> getBlockCollisions(CollisionGetter world, Entity entity, AABB box) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        ChunkAwareBlockCollisionSweeper sweeper = new ChunkAwareBlockCollisionSweeper(world, entity, box);
        while (sweeper.hasNext()) {
            shapes.add((VoxelShape)sweeper.next());
        }
        return shapes;
    }

    public static boolean doesBoxCollideWithBlocks(CollisionGetter world, Entity entity, AABB box) {
        ChunkAwareBlockCollisionSweeper sweeper = new ChunkAwareBlockCollisionSweeper(world, entity, box);
        VoxelShape shape = sweeper.computeNext();
        return shape != null && !shape.m_83281_();
    }

    public static boolean doesBoxCollideWithHardEntities(EntityGetter view, Entity entity, AABB box) {
        if (LithiumEntityCollisions.isBoxEmpty(box)) {
            return false;
        }
        return LithiumEntityCollisions.getEntityWorldBorderCollisionIterable(view, entity, box.m_82400_(1.0E-7), false).iterator().hasNext();
    }

    public static List<VoxelShape> getEntityWorldBorderCollisions(Level world, Entity entity, AABB box, boolean includeWorldBorder) {
        if (LithiumEntityCollisions.isBoxEmpty(box)) {
            return Collections.emptyList();
        }
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        Iterable<VoxelShape> collisions = LithiumEntityCollisions.getEntityWorldBorderCollisionIterable((EntityGetter)world, entity, box.m_82400_(1.0E-7), includeWorldBorder);
        for (VoxelShape shape : collisions) {
            shapes.add(shape);
        }
        return shapes;
    }

    public static Iterable<VoxelShape> getEntityWorldBorderCollisionIterable(final EntityGetter view, final Entity entity, final AABB box, final boolean includeWorldBorder) {
        assert (!includeWorldBorder || entity != null);
        return new Iterable<VoxelShape>(){
            private List<Entity> entityList;
            private int nextFilterIndex;

            @Override
            @NotNull
            public Iterator<VoxelShape> iterator() {
                return new AbstractIterator<VoxelShape>(){
                    int index = 0;
                    boolean consumedWorldBorder = false;

                    protected VoxelShape computeNext() {
                        Entity otherEntity;
                        if (entityList == null) {
                            entityList = WorldHelper.getEntitiesForCollision(view, box, entity);
                            nextFilterIndex = 0;
                        }
                        List<Entity> list = entityList;
                        do {
                            if (this.index >= list.size()) {
                                if (includeWorldBorder && !this.consumedWorldBorder) {
                                    this.consumedWorldBorder = true;
                                    WorldBorder worldBorder = entity.f_19853_.m_6857_();
                                    if (!LithiumEntityCollisions.isWithinWorldBorder(worldBorder, box) && LithiumEntityCollisions.isWithinWorldBorder(worldBorder, entity.m_20191_())) {
                                        return worldBorder.m_61946_();
                                    }
                                }
                                return (VoxelShape)this.endOfData();
                            }
                            otherEntity = list.get(this.index);
                            if (this.index >= nextFilterIndex) {
                                if (entity == null) {
                                    if (!otherEntity.m_5829_()) {
                                        otherEntity = null;
                                    }
                                } else if (!entity.m_7337_(otherEntity)) {
                                    otherEntity = null;
                                }
                                ++nextFilterIndex;
                            }
                            ++this.index;
                        } while (otherEntity == null);
                        return Shapes.m_83064_((AABB)otherEntity.m_20191_());
                    }
                };
            }
        };
    }

    public static boolean isWithinWorldBorder(WorldBorder border, AABB box) {
        double wboxMinX = Math.floor(border.m_61955_());
        double wboxMinZ = Math.floor(border.m_61956_());
        double wboxMaxX = Math.ceil(border.m_61957_());
        double wboxMaxZ = Math.ceil(border.m_61958_());
        return box.f_82288_ >= wboxMinX && box.f_82288_ <= wboxMaxX && box.f_82290_ >= wboxMinZ && box.f_82290_ <= wboxMaxZ && box.f_82291_ >= wboxMinX && box.f_82291_ <= wboxMaxX && box.f_82293_ >= wboxMinZ && box.f_82293_ <= wboxMaxZ;
    }

    private static boolean isBoxEmpty(AABB box) {
        return box.m_82309_() <= 1.0E-7;
    }

    public static boolean doesEntityCollideWithWorldBorder(CollisionGetter collisionView, Entity entity) {
        if (LithiumEntityCollisions.isWithinWorldBorder(collisionView.m_6857_(), entity.m_20191_())) {
            return false;
        }
        VoxelShape worldBorderShape = LithiumEntityCollisions.getWorldBorderCollision(collisionView, entity);
        return worldBorderShape != null && Shapes.m_83157_((VoxelShape)worldBorderShape, (VoxelShape)Shapes.m_83064_((AABB)entity.m_20191_()), (BooleanOp)BooleanOp.f_82689_);
    }

    public static VoxelShape getWorldBorderCollision(CollisionGetter collisionView, Entity entity) {
        AABB box = entity.m_20191_();
        WorldBorder worldBorder = collisionView.m_6857_();
        return worldBorder.m_187566_(entity, box) ? worldBorder.m_61946_() : null;
    }
}

