/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import org.popcraft.chunky.ChunkyForge;
import org.popcraft.chunky.integration.Integration;
import org.popcraft.chunky.platform.Config;
import org.popcraft.chunky.platform.ForgePlayer;
import org.popcraft.chunky.platform.ForgeSender;
import org.popcraft.chunky.platform.ForgeWorld;
import org.popcraft.chunky.platform.Player;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.Server;
import org.popcraft.chunky.platform.World;

public class ForgeServer
implements Server {
    private final ChunkyForge plugin;
    private final MinecraftServer server;

    public ForgeServer(ChunkyForge plugin, MinecraftServer server) {
        this.plugin = plugin;
        this.server = server;
    }

    @Override
    public Map<String, Integration> getIntegrations() {
        return Map.of();
    }

    @Override
    public Optional<World> getWorld(String name) {
        return Optional.ofNullable(ResourceLocation.m_135820_((String)name)).map(resourceLocation -> this.server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)resourceLocation))).map(ForgeWorld::new);
    }

    @Override
    public List<World> getWorlds() {
        ArrayList<World> worlds = new ArrayList<World>();
        this.server.m_129785_().forEach(world -> worlds.add(new ForgeWorld((ServerLevel)world)));
        return worlds;
    }

    @Override
    public Sender getConsole() {
        return new ForgeSender(this.server.m_129893_());
    }

    @Override
    public Collection<Player> getPlayers() {
        return this.server.m_6846_().m_11314_().stream().map(ForgePlayer::new).collect(Collectors.toList());
    }

    @Override
    public Optional<Player> getPlayer(String name) {
        return Optional.ofNullable(this.server.m_6846_().m_11255_(name)).map(ForgePlayer::new);
    }

    @Override
    public Config getConfig() {
        return this.plugin.getChunky().getConfig();
    }
}

