/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.popcraft.chunky.nbt.ByteArrayTag;
import org.popcraft.chunky.nbt.ByteTag;
import org.popcraft.chunky.nbt.CompoundTag;
import org.popcraft.chunky.nbt.DoubleTag;
import org.popcraft.chunky.nbt.EndTag;
import org.popcraft.chunky.nbt.FloatTag;
import org.popcraft.chunky.nbt.IntArrayTag;
import org.popcraft.chunky.nbt.IntTag;
import org.popcraft.chunky.nbt.ListTag;
import org.popcraft.chunky.nbt.LongArrayTag;
import org.popcraft.chunky.nbt.LongTag;
import org.popcraft.chunky.nbt.ShortTag;
import org.popcraft.chunky.nbt.StringTag;

public abstract class Tag {
    protected static final int INDENT = 2;
    protected final String name;

    protected Tag(String name) {
        this.name = name;
    }

    public static Tag load(DataInput input) throws IOException {
        byte type = input.readByte();
        if (0 == type) {
            return new EndTag();
        }
        String name = input.readUTF();
        Tag tag = Tag.create(type, name);
        tag.read(input);
        return tag;
    }

    public static void save(DataOutput output, Tag tag) throws IOException {
        byte type = tag.type();
        output.writeByte(type);
        if (0 == type) {
            return;
        }
        output.writeUTF(tag.name());
        tag.write(output);
    }

    public static Tag create(byte type, String name) {
        return switch (type) {
            case 0 -> new EndTag();
            case 1 -> new ByteTag(name);
            case 2 -> new ShortTag(name);
            case 3 -> new IntTag(name);
            case 4 -> new LongTag(name);
            case 5 -> new FloatTag(name);
            case 6 -> new DoubleTag(name);
            case 7 -> new ByteArrayTag(name);
            case 8 -> new StringTag(name);
            case 9 -> new ListTag(name);
            case 10 -> new CompoundTag(name);
            case 11 -> new IntArrayTag(name);
            case 12 -> new LongArrayTag(name);
            default -> throw new IllegalArgumentException("Invalid tag type %d".formatted(type));
        };
    }

    public String name() {
        return this.name;
    }

    abstract void read(DataInput var1) throws IOException;

    abstract void write(DataOutput var1) throws IOException;

    abstract byte type();

    abstract String typeName();

    abstract String print(int var1);

    public String toString() {
        return this.print(0);
    }
}

