/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.util.ArrayList;
import java.util.List;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.command.CommandArguments;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.util.Input;
import org.popcraft.chunky.util.Translator;

public class HelpCommand
implements ChunkyCommand {
    private final Chunky chunky;
    private final List<String> helpCommands = List.of("start", "pause", "continue", "cancel", "world", "worldborder", "center", "spawn", "radius", "corners", "shape", "pattern", "silent", "quiet", "trim", "selection", "progress", "border", "reload");

    public HelpCommand(Chunky chunky) {
        this.chunky = chunky;
    }

    @Override
    public void execute(Sender sender, CommandArguments arguments) {
        int helpIndexLast;
        ArrayList<String> visibleCommands = new ArrayList<String>();
        for (String command : this.helpCommands) {
            if (!this.chunky.getCommands().containsKey(command)) continue;
            visibleCommands.add(command);
        }
        int visibleCommandCount = visibleCommands.size();
        StringBuilder help = new StringBuilder();
        int pageIndexLast = visibleCommandCount / 8;
        int pageIndex = (arguments.size() < 1 ? 0 : Math.max(0, arguments.next().flatMap(Input::tryInteger).orElse(1) - 1)) % (pageIndexLast + 1);
        if (sender.isPlayer()) {
            helpIndexFirst = 8 * pageIndex;
            helpIndexLast = Math.min(helpIndexFirst + 8, visibleCommandCount);
        } else {
            helpIndexFirst = 0;
            helpIndexLast = visibleCommandCount;
        }
        for (int i = helpIndexFirst; i < helpIndexLast; ++i) {
            help.append('\n').append(Translator.translate("help_" + (String)visibleCommands.get(i), new Object[0]));
        }
        if (sender.isPlayer() && pageIndex != pageIndexLast) {
            help.append('\n').append(Translator.translate("help_more", "/chunky help " + (pageIndex + 2)));
        }
        sender.sendMessage("help_menu", help.toString());
    }

    @Override
    public List<String> suggestions(CommandArguments arguments) {
        return List.of();
    }
}

