/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.widgets.DebouncedSlider;
import de.maxhenkel.voicechat.gui.widgets.MicTestButton;
import de.maxhenkel.voicechat.natives.RNNoiseManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.common.AudioUtils;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class VoiceActivationSlider
extends DebouncedSlider
implements MicTestButton.MicListener {
    private static final ResourceLocation SLIDER = new ResourceLocation("voicechat", "textures/gui/voice_activation_slider.png");
    private static final Component NO_ACTIVATION = Component.m_237115_((String)"message.voicechat.voice_activation.disabled").m_130940_(ChatFormatting.RED);
    private final SlidingMaxSmooth micValue;

    public VoiceActivationSlider(int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.m_237119_(), AudioUtils.dbToPerc(VoicechatClient.CLIENT_CONFIG.voiceActivationThreshold.get().floatValue()));
        this.m_5695_();
        this.micValue = new SlidingMaxSmooth();
    }

    public boolean shouldShowSlider() {
        if (!MicrophoneActivationType.VOICE.equals((Object)VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get())) {
            return false;
        }
        if (!RNNoiseManager.canUseDenoiser()) {
            return true;
        }
        return VoicechatClient.CLIENT_CONFIG.vad.get() == false;
    }

    protected void m_7906_(PoseStack poseStack, Minecraft minecraft, int i, int j) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)SLIDER);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int width = (int)((double)(this.m_5711_() - 2) * this.micValue.smoothMax());
        this.m_93228_(poseStack, this.f_93620_ + 1, this.f_93621_ + 1, 0, 0, width, 18);
        boolean shouldShow = this.shouldShowSlider();
        if (shouldShow != this.f_93623_) {
            this.f_93623_ = shouldShow;
            this.m_5695_();
        }
        if (!this.f_93623_) {
            return;
        }
        super.m_7906_(poseStack, minecraft, i, j);
    }

    protected void m_5695_() {
        if (!this.f_93623_) {
            this.m_93666_((Component)Component.m_237119_());
            return;
        }
        long db = Math.round(AudioUtils.percToDb(this.f_93577_));
        MutableComponent component = Component.m_237110_((String)"message.voicechat.voice_activation", (Object[])new Object[]{db});
        if (db >= -10L) {
            component.m_130940_(ChatFormatting.RED);
        }
        this.m_93666_((Component)component);
    }

    @Nullable
    public Component getHoverText() {
        if (!this.f_93623_) {
            return null;
        }
        if (this.f_93577_ >= 1.0) {
            return NO_ACTIVATION;
        }
        return null;
    }

    public boolean isHovered() {
        return this.f_93622_;
    }

    @Override
    public void applyDebounced() {
        VoicechatClient.CLIENT_CONFIG.voiceActivationThreshold.set(AudioUtils.percToDb(this.f_93577_)).save();
    }

    @Override
    public void onMicValue(double dB) {
        this.micValue.add(AudioUtils.dbToPerc(dB));
    }

    @Override
    public void onStop() {
        this.micValue.reset();
    }

    private static class SlidingMaxSmooth {
        private final double[] values = new double[15];
        private int n;
        private int p;
        private static final double SMOOTHING_PER_SEC = 25.0;
        private double smoothed;
        private long lastNs = -1L;

        private SlidingMaxSmooth() {
        }

        public void add(double x) {
            if (this.n < this.values.length) {
                ++this.n;
            }
            this.values[this.p] = x;
            this.p = (this.p + 1) % this.values.length;
        }

        public double max() {
            if (this.n == 0) {
                return 0.0;
            }
            int len = Math.min(this.n, this.values.length);
            double max = this.values[0];
            for (int i = 1; i < len; ++i) {
                if (!(this.values[i] > max)) continue;
                max = this.values[i];
            }
            return max;
        }

        public double smoothMax() {
            long nowNanos = System.nanoTime();
            double target = this.max();
            if (this.lastNs < 0L) {
                this.lastNs = nowNanos;
                this.smoothed = target;
                return this.smoothed;
            }
            double dt = (double)(nowNanos - this.lastNs) / 1.0E9;
            this.lastNs = nowNanos;
            double alpha = dt * 25.0;
            if (alpha > 1.0) {
                alpha = 1.0;
            }
            if (alpha < 0.0) {
                alpha = 0.0;
            }
            this.smoothed += (target - this.smoothed) * alpha;
            return this.smoothed;
        }

        public void reset() {
            this.n = 0;
            this.p = 0;
            this.smoothed = 0.0;
            this.lastNs = -1L;
        }
    }
}

