/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkConstants;
import net.minecraftforge.network.NetworkRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerStatusPing {
    private static final Logger LOGGER = LogManager.getLogger();
    private final transient Map<ResourceLocation, Pair<String, Boolean>> channels;
    private final transient Map<String, String> mods;
    private final transient int fmlNetworkVer;
    private final transient boolean truncated;

    public ServerStatusPing() {
        this.channels = NetworkRegistry.buildChannelVersionsForListPing();
        this.mods = new HashMap<String, String>();
        ModList.get().forEachModContainer((modid, mc) -> this.mods.put((String)modid, mc.getCustomExtension(IExtensionPoint.DisplayTest.class).map(IExtensionPoint.DisplayTest::suppliedVersion).map(Supplier::get).orElse("OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31")));
        this.fmlNetworkVer = 3;
        this.truncated = false;
    }

    private ServerStatusPing(Map<ResourceLocation, Pair<String, Boolean>> deserialized, Map<String, String> modMarkers, int fmlNetVer, boolean truncated) {
        this.channels = ImmutableMap.copyOf(deserialized);
        this.mods = modMarkers;
        this.fmlNetworkVer = fmlNetVer;
        this.truncated = truncated;
    }

    public String toString() {
        return "FMLStatusPing{channels=" + String.valueOf(this.channels) + ", mods=" + String.valueOf(this.mods) + ", fmlNetworkVer=" + this.fmlNetworkVer + ", truncated=" + this.truncated + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerStatusPing)) {
            return false;
        }
        ServerStatusPing that = (ServerStatusPing)o;
        return this.fmlNetworkVer == that.fmlNetworkVer && this.channels.equals(that.channels) && this.mods.equals(that.mods);
    }

    public int hashCode() {
        return Objects.hash(this.channels, this.mods, this.fmlNetworkVer);
    }

    private List<Map.Entry<ResourceLocation, Pair<String, Boolean>>> getChannelsForMod(String modId) {
        return this.channels.entrySet().stream().filter(c -> ((ResourceLocation)c.getKey()).m_135827_().equals(modId)).toList();
    }

    private List<Map.Entry<ResourceLocation, Pair<String, Boolean>>> getNonModChannels() {
        return this.channels.entrySet().stream().filter(c -> !this.mods.containsKey(((ResourceLocation)c.getKey()).m_135827_())).toList();
    }

    public Map<ResourceLocation, Pair<String, Boolean>> getRemoteChannels() {
        return this.channels;
    }

    public Map<String, String> getRemoteModData() {
        return this.mods;
    }

    public int getFMLNetworkVersion() {
        return this.fmlNetworkVer;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public static class Serializer {
        private static final int VERSION_FLAG_IGNORESERVERONLY = 1;

        public static ServerStatusPing deserialize(JsonObject forgeData) {
            try {
                if (forgeData.has("d")) {
                    return Serializer.deserializeOptimized(forgeData);
                }
                Map<ResourceLocation, Pair<String, Boolean>> channels = StreamSupport.stream(GsonHelper.m_13933_((JsonObject)forgeData, (String)"channels").spliterator(), false).map(JsonElement::getAsJsonObject).collect(Collectors.toMap(jo -> new ResourceLocation(GsonHelper.m_13906_((JsonObject)jo, (String)"res")), jo -> Pair.of((Object)GsonHelper.m_13906_((JsonObject)jo, (String)"version"), (Object)GsonHelper.m_13912_((JsonObject)jo, (String)"required"))));
                Map<String, String> mods = StreamSupport.stream(GsonHelper.m_13933_((JsonObject)forgeData, (String)"mods").spliterator(), false).map(JsonElement::getAsJsonObject).collect(Collectors.toMap(jo -> GsonHelper.m_13906_((JsonObject)jo, (String)"modId"), jo -> GsonHelper.m_13906_((JsonObject)jo, (String)"modmarker")));
                int remoteFMLVersion = GsonHelper.m_13927_((JsonObject)forgeData, (String)"fmlNetworkVersion");
                boolean truncated = GsonHelper.m_13855_((JsonObject)forgeData, (String)"truncated", (boolean)false);
                return new ServerStatusPing(channels, mods, remoteFMLVersion, truncated);
            }
            catch (JsonSyntaxException | IndexOutOfBoundsException | ResourceLocationException e) {
                LOGGER.debug(NetworkConstants.NETWORK, "Encountered an error parsing status ping data", e);
                return null;
            }
        }

        public static JsonObject serialize(ServerStatusPing forgeData) {
            boolean reachedSizeLimit = false;
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeBoolean(false);
            buf.writeShort(forgeData.mods.size());
            int writtenCount = 0;
            for (Map.Entry<String, String> modEntry : forgeData.mods.entrySet()) {
                boolean isIgnoreServerOnly = modEntry.getValue().equals("OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31");
                List<Map.Entry<ResourceLocation, Pair<String, Boolean>>> channelsForMod = forgeData.getChannelsForMod(modEntry.getKey());
                int channelSizeAndVersionFlag = channelsForMod.size() << 1;
                if (isIgnoreServerOnly) {
                    channelSizeAndVersionFlag |= 1;
                }
                buf.m_130130_(channelSizeAndVersionFlag);
                buf.m_130070_(modEntry.getKey());
                if (!isIgnoreServerOnly) {
                    buf.m_130070_(modEntry.getValue());
                }
                for (Map.Entry<ResourceLocation, Pair<String, Boolean>> entry : channelsForMod) {
                    buf.m_130070_(entry.getKey().m_135815_());
                    buf.m_130070_((String)entry.getValue().getLeft());
                    buf.writeBoolean(((Boolean)entry.getValue().getRight()).booleanValue());
                }
                ++writtenCount;
                if (buf.readableBytes() < 60000) continue;
                reachedSizeLimit = true;
                break;
            }
            if (!reachedSizeLimit) {
                List<Map.Entry<ResourceLocation, Pair<String, Boolean>>> nonModChannels = forgeData.getNonModChannels();
                buf.m_130130_(nonModChannels.size());
                for (Map.Entry<ResourceLocation, Pair<String, Boolean>> entry : nonModChannels) {
                    buf.m_130085_(entry.getKey());
                    buf.m_130070_((String)entry.getValue().getLeft());
                    buf.writeBoolean(((Boolean)entry.getValue().getRight()).booleanValue());
                }
            } else {
                buf.setShort(1, writtenCount);
                buf.m_130130_(0);
            }
            buf.setBoolean(0, reachedSizeLimit);
            JsonObject obj = new JsonObject();
            obj.addProperty("fmlNetworkVersion", (Number)forgeData.fmlNetworkVer);
            obj.addProperty("d", Serializer.encodeOptimized((ByteBuf)buf));
            obj.add("channels", (JsonElement)new JsonArray());
            obj.add("mods", (JsonElement)new JsonArray());
            obj.addProperty("truncated", Boolean.valueOf(true));
            return obj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static ServerStatusPing deserializeOptimized(JsonObject forgeData) {
            HashMap<ResourceLocation, Pair<String, Boolean>> channels;
            HashMap<String, String> mods;
            boolean truncated;
            int remoteFMLVersion = GsonHelper.m_13927_((JsonObject)forgeData, (String)"fmlNetworkVersion");
            FriendlyByteBuf buf = new FriendlyByteBuf(Serializer.decodeOptimized(GsonHelper.m_13906_((JsonObject)forgeData, (String)"d")));
            try {
                truncated = buf.readBoolean();
                int modsSize = buf.readUnsignedShort();
                mods = new HashMap<String, String>();
                channels = new HashMap<ResourceLocation, Pair<String, Boolean>>();
                for (int i = 0; i < modsSize; ++i) {
                    int channelSizeAndVersionFlag = buf.m_130242_();
                    int channelSize = channelSizeAndVersionFlag >>> 1;
                    boolean isIgnoreServerOnly = (channelSizeAndVersionFlag & 1) != 0;
                    String modId = buf.m_130277_();
                    String modVersion = isIgnoreServerOnly ? "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31" : buf.m_130277_();
                    for (int i1 = 0; i1 < channelSize; ++i1) {
                        String channelName = buf.m_130277_();
                        String channelVersion = buf.m_130277_();
                        boolean requiredOnClient = buf.readBoolean();
                        channels.put(new ResourceLocation(modId, channelName), (Pair<String, Boolean>)Pair.of((Object)channelVersion, (Object)requiredOnClient));
                    }
                    mods.put(modId, modVersion);
                }
                int nonModChannelCount = buf.m_130242_();
                for (int i = 0; i < nonModChannelCount; ++i) {
                    ResourceLocation channelName = buf.m_130281_();
                    String channelVersion = buf.m_130277_();
                    boolean requiredOnClient = buf.readBoolean();
                    channels.put(channelName, (Pair<String, Boolean>)Pair.of((Object)channelVersion, (Object)requiredOnClient));
                }
            }
            finally {
                buf.release();
            }
            return new ServerStatusPing(channels, mods, remoteFMLVersion, truncated);
        }

        private static String encodeOptimized(ByteBuf buf) {
            char c;
            int byteLength = buf.readableBytes();
            StringBuilder sb = new StringBuilder();
            sb.append((char)(byteLength & Short.MAX_VALUE));
            sb.append((char)(byteLength >>> 15 & Short.MAX_VALUE));
            int buffer = 0;
            int bitsInBuf = 0;
            while (buf.isReadable()) {
                if (bitsInBuf >= 15) {
                    c = (char)(buffer & Short.MAX_VALUE);
                    sb.append(c);
                    buffer >>>= 15;
                    bitsInBuf -= 15;
                }
                short b = buf.readUnsignedByte();
                buffer |= b << bitsInBuf;
                bitsInBuf += 8;
            }
            if (bitsInBuf > 0) {
                c = (char)(buffer & Short.MAX_VALUE);
                sb.append(c);
            }
            return sb.toString();
        }

        private static ByteBuf decodeOptimized(String s) {
            char size0 = s.charAt(0);
            char size1 = s.charAt(1);
            int size = size0 | size1 << 15;
            ByteBuf buf = Unpooled.buffer((int)size);
            int buffer = 0;
            int bitsInBuf = 0;
            for (int stringIndex = 2; stringIndex < s.length(); ++stringIndex) {
                while (bitsInBuf >= 8) {
                    buf.writeByte(buffer);
                    buffer >>>= 8;
                    bitsInBuf -= 8;
                }
                char c = s.charAt(stringIndex);
                buffer |= (c & Short.MAX_VALUE) << bitsInBuf;
                bitsInBuf += 15;
            }
            while (buf.readableBytes() < size) {
                buf.writeByte(buffer);
                buffer >>>= 8;
                bitsInBuf -= 8;
            }
            return buf;
        }
    }
}

