/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.cave_dweller.entities.goals;

import de.cadentem.cave_dweller.config.ServerConfig;
import de.cadentem.cave_dweller.entities.CaveDwellerEntity;
import de.cadentem.cave_dweller.entities.goals.Roll;
import de.cadentem.cave_dweller.util.Utils;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;

public class CaveDwellerChaseGoal
extends Goal {
    private final CaveDwellerEntity caveDweller;
    private final int maxSpeedReached;
    private final boolean followTargetEvenIfNotSeen;
    private long lastGameTimeCheck;
    private int ticksUntilLeave;
    private int ticksUntilNextAttack;
    private int speedUp;

    public CaveDwellerChaseGoal(CaveDwellerEntity caveDweller, boolean followTargetEvenIfNotSeen) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.caveDweller = caveDweller;
        this.followTargetEvenIfNotSeen = followTargetEvenIfNotSeen;
        this.ticksUntilLeave = Utils.secondsToTicks((Integer)ServerConfig.TIME_UNTIL_LEAVE_CHASE.get());
        this.maxSpeedReached = Utils.secondsToTicks(3);
    }

    public boolean m_8036_() {
        boolean canAttack;
        if (this.caveDweller.m_20145_()) {
            return false;
        }
        if (this.caveDweller.currentRoll != Roll.CHASE) {
            return false;
        }
        if (!this.caveDweller.targetIsFacingMe) {
            return false;
        }
        long ticks = this.caveDweller.f_19853_.m_46467_();
        if (ticks - this.lastGameTimeCheck < 20L) {
            return false;
        }
        this.lastGameTimeCheck = ticks;
        LivingEntity target = this.caveDweller.m_5448_();
        if (!Utils.isValidPlayer((Entity)target)) {
            return false;
        }
        Path path = this.caveDweller.m_21573_().m_6570_((Entity)target, 0);
        if (path != null) {
            return true;
        }
        boolean bl = canAttack = this.getAttackReachSqr(target) >= this.caveDweller.m_20280_((Entity)target);
        if (canAttack) {
            return true;
        }
        path = this.caveDweller.m_21573_().m_6570_((Entity)target, 0);
        return path != null;
    }

    public boolean m_8045_() {
        LivingEntity target = this.caveDweller.m_5448_();
        if (!Utils.isValidPlayer((Entity)target)) {
            this.caveDweller.disappear();
            return false;
        }
        if (!this.followTargetEvenIfNotSeen) {
            return !this.caveDweller.m_21573_().m_26571_();
        }
        return this.caveDweller.m_21444_(target.m_20183_());
    }

    public void m_8056_() {
        this.caveDweller.m_21561_(true);
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        LivingEntity target = this.caveDweller.m_5448_();
        if (!Utils.isValidPlayer((Entity)target)) {
            this.caveDweller.m_6710_(null);
        }
        this.speedUp = 0;
        this.caveDweller.m_21561_(false);
        this.caveDweller.m_20088_().m_135381_(CaveDwellerEntity.CRAWLING_ACCESSOR, (Object)false);
        this.caveDweller.m_21573_().m_26573_();
        this.caveDweller.m_6210_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        boolean targetMoved;
        LivingEntity target;
        if (this.ticksUntilLeave <= 0 && !this.caveDweller.targetIsFacingMe) {
            this.caveDweller.disappear();
        }
        if (!Utils.isValidPlayer((Entity)(target = this.caveDweller.m_5448_()))) {
            return;
        }
        Path path = this.caveDweller.m_21573_().m_26570_();
        this.fixPath(path);
        boolean bl = targetMoved = path != null && path.m_77395_() != null && path.m_77395_().m_164697_(target.m_20183_()) > 2.0f;
        if (path == null || this.caveDweller.m_21573_().m_26577_() || targetMoved || path.m_77392_() && !this.shouldClimb(path) || this.caveDweller.m_21573_().m_200903_(target.m_20183_()) && this.caveDweller.f_19797_ % 20 == 0) {
            path = this.caveDweller.m_21573_().m_6570_((Entity)target, 0);
            this.fixPath(path);
        }
        if (path != null && !path.m_77392_() && this.caveDweller.m_142582_((Entity)target)) {
            this.caveDweller.playChaseSound();
        }
        this.caveDweller.m_21573_().m_26536_(path, this.caveDweller.getSpeedModifier());
        if (!this.caveDweller.isCrawling()) {
            if (this.caveDweller.m_5912_()) {
                this.caveDweller.m_21563_().m_24960_((Entity)target, 90.0f, 90.0f);
            } else {
                this.caveDweller.m_21563_().m_24960_((Entity)target, 180.0f, 1.0f);
            }
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        double distance = this.caveDweller.m_20280_((Entity)target);
        this.checkAndPerformAttack(target, distance);
        --this.ticksUntilLeave;
        if (this.speedUp < this.maxSpeedReached) {
            ++this.speedUp;
        }
    }

    private void fixPath(Path path) {
        LivingEntity target = this.caveDweller.m_5448_();
        if (target == null) {
            return;
        }
        if (this.shouldClimb(path) && (double)path.m_77375_(0).m_164697_(this.caveDweller.m_5448_().m_20183_()) > 0.1) {
            path.m_77377_(0, path.m_77375_(0).m_77289_(target.m_20183_().m_123341_(), target.m_20183_().m_123342_(), target.m_20183_().m_123343_()));
        }
    }

    private boolean shouldClimb(Path path) {
        if (this.caveDweller.m_5448_() == null) {
            return false;
        }
        return path != null && path.m_77398_() == 1 && (float)this.caveDweller.m_5448_().m_20183_().m_123342_() > (float)this.caveDweller.m_20183_().m_123342_() + this.caveDweller.getStepHeight();
    }

    private void checkAndPerformAttack(LivingEntity target, double distanceToTarget) {
        double attackReach = this.getAttackReachSqr(target);
        if (distanceToTarget <= attackReach && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.caveDweller.m_6674_(InteractionHand.MAIN_HAND);
            this.caveDweller.m_7327_((Entity)target);
        }
    }

    private void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.m_183277_(20);
    }

    private double getAttackReachSqr(LivingEntity target) {
        return this.caveDweller.m_20205_() * 4.0f * this.caveDweller.m_20205_() * 4.0f + target.m_20205_();
    }
}

