/*
 * Decompiled with CFR 0.152.
 */
package com.crispytwig.hearth_and_home.events;

import com.crispytwig.hearth_and_home.integration.IntegrationHandler;
import com.crispytwig.hearth_and_home.registry.ModItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class BlockInteractionEvent {
    public static InteractionResult use(Player player, Level level, InteractionHand hand, BlockHitResult pos) {
        BlockState state = level.m_8055_(pos.m_82425_());
        if (state.m_60713_(Blocks.f_152476_)) {
            return BlockInteractionEvent.cauldronWashing(player, level, state, hand, pos, -1);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult cauldronWashing(Player player, Level level, BlockState state, InteractionHand hand, BlockHitResult pos, int useLiquidChance) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_41852_)) {
            return InteractionResult.PASS;
        }
        if (itemStack.m_204117_(ModItemTags.NOT_WASHABLE)) {
            return InteractionResult.PASS;
        }
        Item result = IntegrationHandler.changeColor(itemStack.m_41720_(), null);
        if (result == null || result == itemStack.m_41720_()) {
            return InteractionResult.PASS;
        }
        CompoundTag nbt = itemStack.m_41783_();
        ItemStack resultStack = new ItemStack((ItemLike)result);
        itemStack.m_41774_(1);
        if (nbt != null) {
            resultStack.m_41784_().m_128391_(nbt);
        }
        player.m_150109_().m_36054_(resultStack);
        if (useLiquidChance != -1 && RandomSource.m_216327_().m_188503_(useLiquidChance) == 0) {
            LayeredCauldronBlock.m_153559_((BlockState)state, (Level)level, (BlockPos)pos.m_82425_());
        }
        level.m_5594_(null, pos.m_82425_(), SoundEvents.f_11917_, SoundSource.BLOCKS, 1.0f, 1.0f);
        player.m_6674_(hand);
        return InteractionResult.SUCCESS;
    }
}

