/*
 * Decompiled with CFR 0.152.
 */
package com.crispytwig.hearth_and_home.block;

import com.crispytwig.hearth_and_home.block.properties.ColumnType;
import com.crispytwig.hearth_and_home.block.properties.ModBlockStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class ColumnBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final EnumProperty<ColumnType> TYPE = ModBlockStateProperties.COLUMN_TYPE;

    public ColumnBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(TYPE, (Comparable)((Object)ColumnType.NONE)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction.Axis axis = context.m_43719_().m_122434_();
        BlockState state = (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)axis);
        state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)this.getType(state, this.getRelativeTop(level, pos, axis), this.getRelativeBottom(level, pos, axis))));
        return state;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.f_46443_) {
            return;
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        ColumnType type = this.getType(state, this.getRelativeTop(level, pos, axis), this.getRelativeBottom(level, pos, axis));
        if (state.m_61143_(TYPE) == type) {
            return;
        }
        state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)type));
        level.m_7731_(pos, state, 3);
    }

    public BlockState getRelativeTop(Level level, BlockPos pos, Direction.Axis axis) {
        return level.m_8055_(pos.m_121945_(Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)));
    }

    public BlockState getRelativeBottom(Level level, BlockPos pos, Direction.Axis axis) {
        return level.m_8055_(pos.m_121945_(Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE)));
    }

    public ColumnType getType(BlockState state, BlockState above, BlockState below) {
        boolean shape_below_same;
        boolean shape_above_same = above.m_60713_(state.m_60734_()) && state.m_61143_(AXIS) == above.m_61143_(AXIS);
        boolean bl = shape_below_same = below.m_60713_(state.m_60734_()) && state.m_61143_(AXIS) == below.m_61143_(AXIS);
        if (shape_above_same && !shape_below_same) {
            return ColumnType.BOTTOM;
        }
        if (!shape_above_same && shape_below_same) {
            return ColumnType.TOP;
        }
        if (shape_above_same) {
            return ColumnType.MIDDLE;
        }
        return ColumnType.NONE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, AXIS});
    }
}

