/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack;

import com.mrcrayfish.backpacked.client.ClientHandler;
import com.mrcrayfish.backpacked.common.Backpack;
import com.mrcrayfish.backpacked.common.IProgressTracker;
import com.mrcrayfish.backpacked.common.ProgressFormatters;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.npc.WanderingTrader;

public class WanderingBagBackpack
extends Backpack {
    public static final ResourceLocation ID = new ResourceLocation("backpacked", "wandering_bag");

    public WanderingBagBackpack() {
        super(ID);
    }

    @Override
    public Supplier<Object> getModelSupplier() {
        return ClientHandler.getModelInstances()::getWanderingBag;
    }

    @Override
    @Nullable
    protected IProgressTracker createProgressTracker() {
        return new PickpocketProgressTracker();
    }

    public static class PickpocketProgressTracker
    implements IProgressTracker {
        private static final int COUNT = 2;
        private final Set<UUID> traders = new HashSet<UUID>();

        public void addTrader(WanderingTrader trader, ServerPlayer player) {
            this.traders.add(trader.m_20148_());
            this.markForCompletionTest(player);
        }

        @Override
        public boolean isComplete() {
            return this.traders.size() >= 2;
        }

        @Override
        public void read(CompoundTag tag) {
            this.traders.clear();
            ListTag list = tag.m_128437_("PickpocketTraders", 10);
            list.forEach(t -> {
                CompoundTag uuidTag = (CompoundTag)t;
                long mostBits = uuidTag.m_128454_("Most");
                long leastBits = uuidTag.m_128454_("Least");
                this.traders.add(new UUID(mostBits, leastBits));
            });
        }

        @Override
        public void write(CompoundTag tag) {
            ListTag list = new ListTag();
            this.traders.forEach(uuid -> {
                CompoundTag uuidTag = new CompoundTag();
                uuidTag.m_128356_("Most", uuid.getMostSignificantBits());
                uuidTag.m_128356_("Least", uuid.getLeastSignificantBits());
                list.add((Object)uuidTag);
            });
            tag.m_128365_("PickpocketTraders", (Tag)list);
        }

        @Override
        public Component getDisplayComponent() {
            return ProgressFormatters.PICKPOCKETED_X_OF_X.apply(this.traders.size(), 2);
        }
    }
}

