/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.old_goatman.events;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import de.cadentem.old_goatman.OldGoatman;
import de.cadentem.old_goatman.config.ServerConfig;
import de.cadentem.old_goatman.entities.OldGoatmanEntity;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="old_goatman", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    public static final ConcurrentHashMap<Integer, Integer> HIT_COUNTER = new ConcurrentHashMap();

    @SubscribeEvent
    public static void handleHurt(LivingAttackEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof OldGoatmanEntity) {
            boolean increaseCounter;
            OldGoatmanEntity oldGoatman = (OldGoatmanEntity)entity;
            boolean skipDamage = event.getSource() == DamageSource.f_19312_ || event.getSource() == DamageSource.f_19317_ || event.getSource() == DamageSource.f_19310_;
            boolean bl = increaseCounter = event.getSource() == DamageSource.f_19312_ || event.getSource() == DamageSource.f_19317_;
            if (skipDamage) {
                if (increaseCounter && !oldGoatman.f_19853_.m_5776_()) {
                    HIT_COUNTER.merge(oldGoatman.m_19879_(), 1, Integer::sum);
                    if (HIT_COUNTER.get(oldGoatman.m_19879_()) > 5) {
                        HIT_COUNTER.remove(oldGoatman.m_19879_());
                        boolean couldTeleport = oldGoatman.teleportToTarget();
                        oldGoatman.f_19864_ = true;
                        if (!couldTeleport) {
                            String key = oldGoatman.f_19853_.m_46472_().m_135782_().toString();
                            if (ServerConfig.isValidDimension(key)) {
                                int spawnDelta = (int)((double)((Integer)ServerConfig.CAN_SPAWN_MIN.get()).intValue() * 0.3);
                                int noiseDelta = (int)((double)((Integer)ServerConfig.RESET_NOISE_MIN.get()).intValue() * 0.3);
                                OldGoatman.speedUpTimers(key, spawnDelta, noiseDelta);
                            }
                            oldGoatman.disappear();
                        }
                    }
                }
                event.setCanceled(true);
            } else if (event.getSource() == DamageSource.f_19315_) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void handleDimensionChange(EntityTravelToDimensionEvent event) {
        OldGoatman.RELOAD_MISSING = true;
    }

    @SubscribeEvent
    public static void handleKnockback(LivingKnockBackEvent event) {
        OldGoatmanEntity oldGoatman;
        LivingEntity entity = event.getEntity();
        if (entity instanceof OldGoatmanEntity && (oldGoatman = (OldGoatmanEntity)entity).isClimbing()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void registerEvents(RegisterCommandsEvent event) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"old_goatman").requires(source -> source.m_6761_(2));
        builder.then(Commands.m_82127_((String)"fast_forward").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"spawn_delta_ticks", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"noise_delta_ticks", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int noiseDelta;
            int spawnDelta;
            String dimension = DimensionArgument.m_88808_((CommandContext)context, (String)"dimension").m_46472_().m_135782_().toString();
            boolean wasSuccessful = OldGoatman.speedUpTimers(dimension, spawnDelta = IntegerArgumentType.getInteger((CommandContext)context, (String)"spawn_delta_ticks"), noiseDelta = IntegerArgumentType.getInteger((CommandContext)context, (String)"noise_delta_ticks"));
            if (wasSuccessful) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)"Timer has been successfully changed"), true);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Timer for dimension [" + dimension + "] does not exist")));
            }
            return 1;
        })))));
        builder.then(Commands.m_82127_((String)"get_target").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(context -> {
            String dimension = DimensionArgument.m_88808_((CommandContext)context, (String)"dimension").m_46472_().m_135782_().toString();
            Entity currentVictim = OldGoatman.getCurrentVictim(dimension);
            if (currentVictim != null) {
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)currentVictim.toString()), true);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Timer for dimension [" + dimension + "] does not exist or has no target")));
            }
            return 1;
        })));
        builder.then(Commands.m_82127_((String)"get_timer").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.string()).suggests((context, suggestionsBuilder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"spawn", "noise"}, (SuggestionsBuilder)suggestionsBuilder)).executes(context -> {
            String type;
            String dimension = DimensionArgument.m_88808_((CommandContext)context, (String)"dimension").m_46472_().m_135782_().toString();
            Pair<Integer, Integer> timer = OldGoatman.getTimer(dimension, type = StringArgumentType.getString((CommandContext)context, (String)"type"));
            if ((Integer)timer.getFirst() != -1 && (Integer)timer.getSecond() != -1) {
                double currentSeconds = (double)((Integer)timer.getFirst()).intValue() / 20.0;
                double targetSeconds = (double)((Integer)timer.getSecond()).intValue() / 20.0;
                ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)(currentSeconds + " / " + targetSeconds + " seconds")), true);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Timer for dimension [" + dimension + "] does not exist")));
            }
            return 1;
        }))));
        event.getDispatcher().register(builder);
    }
}

