/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.util;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.ordana.immersive_weathering.blocks.LeafPileBlock;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.mixins.accessors.BiomeAccessor;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModParticles;
import com.ordana.immersive_weathering.reg.ModTags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class WeatheringHelper {
    public static final Supplier<BiMap<Block, Block>> FLOWERY_BLOCKS = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)Blocks.f_152542_, (Object)Blocks.f_152541_).put((Object)Blocks.f_152471_, (Object)Blocks.f_152470_).put((Object)((Block)ModBlocks.LEAF_PILES.get(LeavesTypeRegistry.getValue((ResourceLocation)new ResourceLocation("flowering_azalea")))), (Object)((Block)ModBlocks.LEAF_PILES.get(LeavesTypeRegistry.getValue((ResourceLocation)new ResourceLocation("azalea")))));
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "quark:flowering_azalea_hedge", "quark:azalea_hedge");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "quark:flowering_azalea_leaf_carpet", "quark:azalea_leaf_carpet");
        return builder.build();
    });
    public static final Supplier<Map<Block, LeafPileBlock>> LEAVES_TO_PILES = Suppliers.memoize(() -> {
        ImmutableMap.Builder b = ImmutableMap.builder();
        ModBlocks.LEAF_PILES.forEach((key, value) -> b.put((Object)key.leaves, (Object)value));
        return b.build();
    });
    public static final Supplier<Map<Block, SimpleParticleType>> LEAVES_TO_PARTICLE = Suppliers.memoize(() -> {
        ImmutableMap.Builder b = ImmutableMap.builder();
        ModParticles.FALLING_LEAVES_PARTICLES.forEach((key, value) -> b.put((Object)key.leaves, value));
        return b.build();
    });
    public static final Supplier<Map<Block, ParticleOptions>> LOG_TO_PARTICLES = Suppliers.memoize(() -> ImmutableMap.builder().put((Object)Blocks.f_49999_, (Object)((ParticleOptions)ModParticles.OAK_BARK.get())).put((Object)Blocks.f_50004_, (Object)((ParticleOptions)ModParticles.DARK_OAK_BARK.get())).put((Object)Blocks.f_50000_, (Object)((ParticleOptions)ModParticles.SPRUCE_BARK.get())).put((Object)Blocks.f_50001_, (Object)((ParticleOptions)ModParticles.BIRCH_BARK.get())).put((Object)Blocks.f_50002_, (Object)((ParticleOptions)ModParticles.JUNGLE_BARK.get())).put((Object)Blocks.f_50003_, (Object)((ParticleOptions)ModParticles.ACACIA_BARK.get())).put((Object)Blocks.f_220832_, (Object)((ParticleOptions)ModParticles.MANGROVE_BARK.get())).put((Object)Blocks.f_50695_, (Object)((ParticleOptions)ModParticles.NETHER_SCALE.get())).put((Object)Blocks.f_50686_, (Object)((ParticleOptions)ModParticles.NETHER_SCALE.get())).put((Object)Blocks.f_50011_, (Object)((ParticleOptions)ModParticles.OAK_BARK.get())).put((Object)Blocks.f_50043_, (Object)((ParticleOptions)ModParticles.DARK_OAK_BARK.get())).put((Object)Blocks.f_50012_, (Object)((ParticleOptions)ModParticles.SPRUCE_BARK.get())).put((Object)Blocks.f_50013_, (Object)((ParticleOptions)ModParticles.BIRCH_BARK.get())).put((Object)Blocks.f_50014_, (Object)((ParticleOptions)ModParticles.JUNGLE_BARK.get())).put((Object)Blocks.f_50015_, (Object)((ParticleOptions)ModParticles.ACACIA_BARK.get())).put((Object)Blocks.f_220836_, (Object)((ParticleOptions)ModParticles.MANGROVE_BARK.get())).put((Object)Blocks.f_50697_, (Object)((ParticleOptions)ModParticles.NETHER_SCALE.get())).put((Object)Blocks.f_50688_, (Object)((ParticleOptions)ModParticles.NETHER_SCALE.get())).build());

    public static void addOptional(ImmutableBiMap.Builder<Block, Block> map, String moddedId, String moddedId2) {
        Optional o1 = Registry.f_122824_.m_6612_(new ResourceLocation(moddedId));
        Optional o2 = Registry.f_122824_.m_6612_(new ResourceLocation(moddedId2));
        if (o1.isPresent() && o2.isPresent()) {
            map.put((Object)((Block)o1.get()), (Object)((Block)o2.get()));
        }
    }

    public static Optional<BlockState> getAzaleaGrowth(BlockState state) {
        return Optional.ofNullable((Block)FLOWERY_BLOCKS.get().inverse().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }

    public static Optional<BlockState> getAzaleaSheared(BlockState state) {
        return Optional.ofNullable((Block)FLOWERY_BLOCKS.get().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
    }

    public static ParticleOptions getBarkParticle(BlockState state) {
        return LOG_TO_PARTICLES.get().getOrDefault(state.m_60734_(), (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state));
    }

    public static Optional<Block> getFallenLeafPile(BlockState state) {
        Block b = state.m_60734_();
        if (CommonConfigs.LEAF_PILES_BLACKLIST.get().contains(Registry.f_122824_.m_7981_((Object)b).toString())) {
            return Optional.empty();
        }
        return Optional.ofNullable((Block)LEAVES_TO_PILES.get().get(b));
    }

    public static Optional<SimpleParticleType> getFallenLeafParticle(BlockState state) {
        Block b = state.m_60734_();
        return Optional.ofNullable(LEAVES_TO_PARTICLE.get().get(b));
    }

    @Nullable
    public static Item getBarkToStrip(BlockState normalLog) {
        WoodType woodType = (WoodType)BlockSetAPI.getBlockTypeOf((ItemLike)normalLog.m_60734_(), WoodType.class);
        if (woodType != null) {
            boolean log = false;
            String childKey = woodType.getChildKey((Object)normalLog.m_60734_());
            if ("log".equals(childKey) && woodType.getChild("stripped_log") != null || "wood".equals(childKey) && woodType.getChild("stripped_wood") != null) {
                log = true;
            }
            if (log) {
                Optional bark;
                String s = CommonConfigs.GENERIC_BARK.get();
                if (!s.isEmpty() && (bark = Registry.f_122827_.m_6612_(new ResourceLocation(s))).isPresent()) {
                    return (Item)bark.get();
                }
                return woodType.getItemOfThis("immersive_weathering:bark");
            }
        }
        return null;
    }

    public static Optional<Pair<Item, Block>> getBarkForStrippedLog(BlockState stripped) {
        WoodType woodType = (WoodType)BlockSetAPI.getBlockTypeOf((ItemLike)stripped.m_60734_(), WoodType.class);
        if (woodType != null) {
            Object log = null;
            if (woodType.getChild("stripped_log") == stripped.m_60734_()) {
                log = woodType.getChild("log");
            } else if (woodType.getChild("stripped_wood") == stripped.m_60734_()) {
                log = woodType.getChild("wood");
            }
            if (log instanceof Block) {
                Block unStripped = (Block)log;
                String s = CommonConfigs.GENERIC_BARK.get();
                if (!s.isEmpty()) {
                    Optional bark = Registry.f_122827_.m_6612_(new ResourceLocation(s));
                    if (bark.isPresent()) {
                        return Optional.of(Pair.of((Object)((Item)bark.get()), (Object)unStripped));
                    }
                } else {
                    Item bark = woodType.getItemOfThis("immersive_weathering:bark");
                    if (bark != null) {
                        return Optional.of(Pair.of((Object)bark, (Object)unStripped));
                    }
                }
            }
        }
        return Optional.empty();
    }

    public static List<BlockPos> grabBlocksAroundRandomly(BlockPos centerPos, int radiusX, int radiusY, int radiusZ) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(BlockPos.m_121985_((BlockPos)centerPos, (int)radiusX, (int)radiusY, (int)radiusZ).map(BlockPos::new).toList());
        Collections.shuffle(list, new Random(Mth.m_14057_((Vec3i)centerPos)));
        return list;
    }

    public static boolean hasEnoughBlocksAround(BlockPos centerPos, int radiusX, int radiusY, int radiusZ, Level level, Predicate<BlockState> blockPredicate, int requiredAmount) {
        List<BlockPos> lis = WeatheringHelper.grabBlocksAroundRandomly(centerPos, radiusX, radiusY, radiusZ);
        int count = 0;
        for (BlockPos pos : lis) {
            if (blockPredicate.test(level.m_8055_(pos))) {
                ++count;
            }
            if (count < requiredAmount) continue;
            return true;
        }
        return false;
    }

    public static boolean hasEnoughBlocksAround(BlockPos centerPos, int radius, Level level, Predicate<BlockState> blockPredicate, int requiredAmount) {
        return WeatheringHelper.hasEnoughBlocksAround(centerPos, radius, radius, radius, level, blockPredicate, requiredAmount);
    }

    public static boolean hasEnoughBlocksFacingMe(BlockPos centerPos, Level level, Predicate<BlockState> blockPredicate, int requiredAmount) {
        int count = 0;
        ArrayList<Direction> list = new ArrayList<Direction>(List.of(Direction.values()));
        Collections.shuffle(list, new Random(Mth.m_14057_((Vec3i)centerPos)));
        for (Direction dir : list) {
            BlockPos pos = centerPos.m_121945_(dir);
            if (blockPredicate.test(level.m_8055_(pos))) {
                ++count;
            }
            if (count < requiredAmount) continue;
            return true;
        }
        return false;
    }

    public static boolean isLog(BlockState state) {
        return state.m_204336_(BlockTags.f_13106_) && (!state.m_61138_((Property)RotatedPillarBlock.f_55923_) || state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y) && !Registry.f_122824_.m_7981_((Object)state.m_60734_()).m_135815_().contains("stripped");
    }

    public static boolean isIciclePos(BlockPos pos) {
        int rarity = CommonConfigs.ICICLE_RARITY.get();
        Random posRandom = new Random(Mth.m_14057_((Vec3i)pos));
        if (CommonConfigs.DISABLE_ICICLES.get().booleanValue()) {
            return false;
        }
        return posRandom.nextInt(rarity) == 0;
    }

    public static boolean isRandomWeatheringPos(BlockPos pos) {
        Random posRandom = new Random(Mth.m_14057_((Vec3i)pos));
        return posRandom.nextInt(6) == 0;
    }

    public static void onFireExpired(ServerLevel serverLevel, BlockPos pos, BlockState state) {
    }

    @Nullable
    public static BlockState getCharredState(BlockState state) {
        Block charred = null;
        if (state.m_204336_(BlockTags.f_13098_)) {
            charred = ModBlocks.CHARRED_FENCE.get();
        } else if (state.m_204336_(BlockTags.f_13055_)) {
            charred = ModBlocks.CHARRED_FENCE_GATE.get();
        } else if (state.m_204336_(BlockTags.f_13097_)) {
            charred = ModBlocks.CHARRED_SLAB.get();
        } else if (state.m_204336_(BlockTags.f_13096_)) {
            charred = ModBlocks.CHARRED_STAIRS.get();
        } else if (state.m_204336_(BlockTags.f_13090_)) {
            charred = ModBlocks.CHARRED_PLANKS.get();
        } else if (state.m_204336_(BlockTags.f_13105_)) {
            charred = ModBlocks.CHARRED_LOG.get();
        }
        if (charred == null) {
            return null;
        }
        return charred.m_152465_(state);
    }

    public boolean ashStuff(BlockState state, Level level, BlockPos pos) {
        BlockState downState = level.m_8055_(pos.m_7495_());
        if (!(level.f_46441_.m_188501_() > 0.2f) && downState.m_60713_(Blocks.f_50440_)) {
            return level.m_46597_(pos.m_7495_(), Blocks.f_50493_.m_49966_());
        }
        return false;
    }

    public static float getTemp(Level level, BlockPos pos) {
        Biome biome = (Biome)level.m_204166_(pos).m_203334_();
        return ((BiomeAccessor)biome).invokeGetTemperature(pos);
    }

    public static boolean isPosWet(Level level, Holder<Biome> biome, BlockPos pos) {
        return biome.m_203656_(ModTags.WET);
    }

    public static boolean isPosHot(Level level, Holder<Biome> biome, BlockPos pos) {
        return biome.m_203656_(ModTags.HOT);
    }

    public static boolean shouldGetWet(ServerLevel world, BlockPos pos) {
        int temperature = 0;
        boolean isTouchingWater = false;
        for (Direction direction : Direction.values()) {
            BlockPos targetPos = pos.m_121945_(direction);
            Holder biome = world.m_204166_(pos);
            BlockState neighborState = world.m_8055_(targetPos);
            if (neighborState.m_60819_().m_205070_(FluidTags.f_13131_)) {
                isTouchingWater = true;
                break;
            }
            if (world.m_46758_(pos.m_121945_(direction))) {
                --temperature;
                continue;
            }
            if (neighborState.m_204336_(ModTags.MAGMA_SOURCE) || world.m_6042_().f_63857_()) {
                ++temperature;
                continue;
            }
            if (WeatheringHelper.isPosWet((Level)world, (Holder<Biome>)biome, pos)) {
                --temperature;
                continue;
            }
            if (!WeatheringHelper.isPosHot((Level)world, (Holder<Biome>)biome, pos)) continue;
            ++temperature;
        }
        return temperature < 0 || isTouchingWater;
    }

    public static void applyFreezing(Entity entity, int freezingIncrement) {
        WeatheringHelper.applyFreezing(entity, freezingIncrement, false);
    }

    public static void applyFreezing(Entity entity, int freezingIncrement, boolean inWater) {
        LivingEntity le;
        if (entity instanceof Player) {
            boolean bl = true;
        }
        if (freezingIncrement != 0 && entity.m_142079_() && entity instanceof LivingEntity && EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44974_, (LivingEntity)(le = (LivingEntity)entity)) <= 0 && !entity.m_6095_().m_204039_(ModTags.LIGHT_FREEZE_IMMUNE)) {
            if (inWater ? le.m_6844_(EquipmentSlot.FEET).m_150930_(Items.f_42463_) : le.m_21023_(MobEffects.f_19592_)) {
                return;
            }
            entity.m_146917_(Math.min(entity.m_146891_(), entity.m_146888_() + freezingIncrement));
        }
    }

    public static void growHangingRoots(ServerLevel level, RandomSource random, BlockPos pos) {
        Direction dir = Direction.values()[1 + random.m_188503_(5)].m_122424_();
        BlockPos targetPos = pos.m_121945_(dir);
        BlockState targetState = level.m_8055_(targetPos);
        if (targetState.m_60767_().m_76336_()) {
            BlockState newState;
            BlockState blockState = newState = dir == Direction.DOWN ? Blocks.f_152548_.m_49966_() : (BlockState)ModBlocks.HANGING_ROOTS_WALL.get().m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)dir);
            if (targetState.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
                newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
            }
            level.m_46597_(targetPos, newState);
        }
    }
}

