/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.reg;

import com.google.common.base.Stopwatch;
import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.data.fluid_generators.ModFluidGenerators;
import com.ordana.immersive_weathering.data.position_tests.ModPositionRuleTests;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;

public class ModSetup {
    private static int setupStage = 0;
    private static final List<Runnable> MOD_SETUP_WORK = List.of(ModSetup::registerCompostables, ModSetup::registerFabricFlammable, ModPositionRuleTests::register, ModFluidGenerators::register);

    public static void setup() {
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            Stopwatch watch = Stopwatch.createStarted();
            for (int i = 0; i < MOD_SETUP_WORK.size(); ++i) {
                setupStage = i;
                MOD_SETUP_WORK.get(i).run();
                list.add(watch.elapsed().toMillis());
                watch.reset();
                watch.start();
            }
            ImmersiveWeathering.LOGGER.info("Finished mod setup in: {} ms", list);
        }
        catch (Exception e) {
            ImmersiveWeathering.LOGGER.error((Object)e);
            ModSetup.terminateWhenSetupFails();
        }
    }

    private static void terminateWhenSetupFails() {
        throw new IllegalStateException("Mod setup has failed to complete (" + setupStage + ").\n This might be due to some mod incompatibility or outdated dependencies (check if everything is up to date).\n Refusing to continue loading with a broken modstate. Next step: crashing this game, no survivors");
    }

    private static void registerFabricFlammable() {
        if (CommonConfigs.FLAMMABLE_COBWEBS.get().booleanValue()) {
            RegHelper.registerBlockFlammability((Block)Blocks.f_50033_, (int)100, (int)100);
        }
        if (CommonConfigs.FLAMMABLE_CROPS.get().booleanValue()) {
            RegHelper.registerBlockFlammability((Block)Blocks.f_50092_, (int)100, (int)100);
            RegHelper.registerBlockFlammability((Block)Blocks.f_50249_, (int)100, (int)100);
            RegHelper.registerBlockFlammability((Block)Blocks.f_50250_, (int)100, (int)100);
            RegHelper.registerBlockFlammability((Block)Blocks.f_50444_, (int)100, (int)100);
        }
    }

    private static void registerCompostables() {
        ModItems.BARK.values().forEach(b -> ComposterBlock.f_51914_.put(b, 0.8f));
        ModBlocks.LEAF_PILES.values().forEach(b -> ComposterBlock.f_51914_.put((Object)b.m_5456_(), 0.3f));
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.MOSS_CLUMP.get()), 0.5f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.AZALEA_FLOWERS.get()), 0.5f);
        ComposterBlock.f_51914_.put((Object)ModBlocks.MULCH_BLOCK.get().m_5456_(), 1.0f);
        ComposterBlock.f_51914_.put((Object)ModBlocks.NULCH_BLOCK.get().m_5456_(), 1.0f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.FLOWER_CROWN.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)ModBlocks.WEEDS.get().m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModBlocks.IVY.get()), 0.3f);
    }
}

