/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.network;

import com.ordana.immersive_weathering.configs.ClientConfigs;
import com.ordana.immersive_weathering.util.WeatheringHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SendCustomParticlesPacket
implements Message {
    private final EventType type;
    private final int extraData;
    private final BlockPos pos;

    public SendCustomParticlesPacket(FriendlyByteBuf buffer) {
        this.extraData = buffer.readInt();
        this.type = EventType.values()[buffer.readByte()];
        this.pos = buffer.m_130135_();
    }

    public SendCustomParticlesPacket(EventType type, BlockPos pos, int extraData) {
        this.type = type;
        this.pos = pos;
        this.extraData = extraData;
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.writeInt(this.extraData);
        buf.writeByte(this.type.ordinal());
        buf.m_130064_(this.pos);
    }

    public void handle(ChannelHandler.Context context) {
        this.clientStuff(this.type, this.pos, this.extraData);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientStuff(EventType type, BlockPos pos, int extraData) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Level level = player.f_19853_;
        if (type == EventType.DECAY_LEAVES) {
            if (ClientConfigs.LEAF_DECAY_PARTICLES.get().booleanValue()) {
                BlockState state = Block.m_49803_((int)extraData);
                SimpleParticleType leafParticle = WeatheringHelper.getFallenLeafParticle(state).orElse(null);
                if (leafParticle == null) {
                    return;
                }
                int color = Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)level, pos, 0);
                double d = (double)pos.m_123341_() + level.f_46441_.m_188500_();
                double e = (double)pos.m_123342_() - 0.05;
                double f = (double)pos.m_123343_() + level.f_46441_.m_188500_();
                level.m_7106_((ParticleOptions)leafParticle, d, e, f, 0.0, (double)color, 0.0);
            }
            if (ClientConfigs.LEAF_DECAY_SOUND.get().booleanValue()) {
                level.m_5594_((Player)player, pos, SoundEvents.f_144073_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public static enum EventType {
        DECAY_LEAVES;

    }
}

