/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.mixins.forge;

import com.mojang.datafixers.util.Pair;
import com.ordana.immersive_weathering.data.fluid_generators.FluidGeneratorsHandler;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FluidInteractionRegistry.class})
public class FluidInteractionRegistryMixin {
    @Inject(method={"canInteract"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void immersiveWeatheringDataFluidInteraction(Level level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        BlockState state = level.m_8055_(pos);
        FlowingFluid f = ((LiquidBlock)state.m_60734_()).getFluid();
        boolean lava = state.m_60819_().m_205070_(FluidTags.f_13132_);
        Optional<Pair<BlockPos, SoundEvent>> successPos = FluidGeneratorsHandler.applyGenerators(f, FluidGeneratorsHandler.POSSIBLE_FLOW_DIRECTIONS, pos, level);
        if (successPos.isPresent()) {
            if (lava) {
                level.m_46796_(1501, pos, 0);
            }
            cir.setReturnValue((Object)false);
        }
    }
}

