/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.mixins;

import com.ordana.immersive_weathering.blocks.snowy.Snowy;
import com.ordana.immersive_weathering.reg.ModTags;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Snowball.class})
public abstract class SnowballMixin
extends ThrowableItemProjectile {
    protected SnowballMixin(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    protected abstract Item m_7881_();

    @Inject(method={"onHit"}, at={@At(value="TAIL")})
    protected void onCollision(HitResult hitResult, CallbackInfo ci) {
        HitResult.Type type = hitResult.m_6662_();
        if (type == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            BlockPos blockPos = blockHitResult.m_82425_();
            BlockState hitState = this.f_19853_.m_8055_(blockPos);
            Optional<BlockState> snowy = Snowy.getSnowy(hitState);
            if (hitState.m_204336_(ModTags.SNOWABLE) && snowy.isPresent()) {
                ParticleUtils.m_216313_((Level)this.f_19853_, (BlockPos)blockPos, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_50127_.m_49966_()), (IntProvider)UniformInt.m_146622_((int)3, (int)5));
                this.f_19853_.m_46597_(blockPos, snowy.get());
            }
        }
    }
}

