/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.mixins;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.ordana.immersive_weathering.IWPlatformStuff;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.data.fluid_generators.FluidGeneratorsHandler;
import com.ordana.immersive_weathering.reg.ModTags;
import com.ordana.immersive_weathering.util.WeatheringHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LiquidBlock.class})
public abstract class LiquidBlockMixin
extends Block
implements BucketPickup {
    @Shadow
    @Final
    public static ImmutableList<Direction> f_181233_;
    @Shadow
    @Final
    protected FlowingFluid f_54689_;

    @Shadow
    protected abstract void m_54700_(LevelAccessor var1, BlockPos var2);

    @Shadow
    public abstract FluidState m_5888_(BlockState var1);

    protected LiquidBlockMixin(BlockBehaviour.Properties settings, FlowingFluid fluid) {
        super(settings);
    }

    @Inject(method={"shouldSpreadLiquid"}, at={@At(value="HEAD")}, cancellable=true)
    private void shouldSpreadLiquid(Level world, BlockPos pos, BlockState state, CallbackInfoReturnable<Boolean> cir) {
        FlowingFluid f = this.getOwnFluid();
        Optional<Pair<BlockPos, SoundEvent>> successPos = FluidGeneratorsHandler.applyGenerators(f, f_181233_, pos, world);
        if (successPos.isPresent()) {
            if (f.m_205067_(FluidTags.f_13132_)) {
                this.m_54700_((LevelAccessor)world, (BlockPos)successPos.get().getFirst());
            }
            cir.setReturnValue((Object)false);
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (CommonConfigs.ENABLE_FREEZING_WATER.get().booleanValue() && !world.f_46443_ && world.m_204166_(pos).m_203656_(ModTags.ICY) && this.getOwnFluid().m_205067_(FluidTags.f_13131_)) {
            LivingEntity livingEntity;
            Integer freezing = CommonConfigs.FREEZING_WATER_SEVERITY.get();
            if (!(entity instanceof LivingEntity) || EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44974_, (LivingEntity)(livingEntity = (LivingEntity)entity)) > 0 || livingEntity.m_21023_(MobEffects.f_19592_) || entity.m_6095_().m_204039_(EntityTypeTags.f_144294_)) {
                return;
            }
            if (entity.m_20069_()) {
                WeatheringHelper.applyFreezing(entity, freezing, true);
            }
        }
    }

    @Unique
    public FlowingFluid getOwnFluid() {
        FlowingFluid f = IWPlatformStuff.getFlowingFluid((LiquidBlock)this);
        if (f == null) {
            return this.f_54689_;
        }
        return f;
    }
}

