/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.integration.forge;

import com.google.common.collect.ImmutableBiMap;
import com.ordana.immersive_weathering.ImmersiveWeathering;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.block.VerticalSlabBlock;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.building.block.VerticalSlabBlock;
import vazkii.quark.content.building.module.VerticalSlabsModule;

public class QuarkPluginImpl {
    private static final EnumProperty<VerticalSlabBlock.VerticalSlabType> QUARK_TYPE = VerticalSlabBlock.TYPE;

    public static void addAllVerticalSlabs(ImmutableBiMap.Builder<Block, Block> builder) {
        ImmutableBiMap map = builder.build();
        for (Map.Entry e : map.entrySet()) {
            if (!(e.getKey() instanceof SlabBlock)) continue;
            String vsName = Utils.getID((Block)((Block)e.getKey())).m_135815_().replace("slab", "vertical_slab");
            String vsAltName = Utils.getID((Block)((Block)e.getValue())).m_135815_().replace("slab", "vertical_slab");
            Block vs = null;
            Block vsAlt = null;
            ResourceLocation vsRes = new ResourceLocation("quark", vsName);
            if (ForgeRegistries.BLOCKS.containsKey(vsRes)) {
                vs = (Block)ForgeRegistries.BLOCKS.getValue(vsRes);
            } else {
                vsRes = ImmersiveWeathering.res(vsName);
                if (ForgeRegistries.BLOCKS.containsKey(vsRes)) {
                    vs = (Block)ForgeRegistries.BLOCKS.getValue(vsRes);
                }
            }
            ResourceLocation vsAltRes = new ResourceLocation("quark", vsAltName);
            if (ForgeRegistries.BLOCKS.containsKey(vsAltRes)) {
                vsAlt = (Block)ForgeRegistries.BLOCKS.getValue(vsAltRes);
            } else {
                vsAltRes = ImmersiveWeathering.res(vsAltName);
                if (ForgeRegistries.BLOCKS.containsKey(vsAltRes)) {
                    vsAlt = (Block)ForgeRegistries.BLOCKS.getValue(vsAltRes);
                }
            }
            if (vs == null || vsAlt == null) continue;
            builder.put((Object)vs, (Object)vsAlt);
        }
    }

    public static BlockState fixVerticalSlab(BlockState fixedBlock, BlockState original) {
        if (fixedBlock.m_61138_(QUARK_TYPE) && original.m_61138_((Property)net.mehvahdjukaar.moonlight.api.block.VerticalSlabBlock.TYPE)) {
            String name = ((VerticalSlabBlock.VerticalSlabType)original.m_61143_((Property)net.mehvahdjukaar.moonlight.api.block.VerticalSlabBlock.TYPE)).toString();
            return (BlockState)fixedBlock.m_61124_(QUARK_TYPE, (Comparable)((VerticalSlabBlock.VerticalSlabType)QUARK_TYPE.m_6215_(name).get()));
        }
        if (fixedBlock.m_61138_((Property)net.mehvahdjukaar.moonlight.api.block.VerticalSlabBlock.TYPE) && original.m_61138_(QUARK_TYPE)) {
            String name = ((VerticalSlabBlock.VerticalSlabType)original.m_61143_(QUARK_TYPE)).toString();
            return (BlockState)fixedBlock.m_61124_((Property)net.mehvahdjukaar.moonlight.api.block.VerticalSlabBlock.TYPE, (Comparable)((VerticalSlabBlock.VerticalSlabType)net.mehvahdjukaar.moonlight.api.block.VerticalSlabBlock.TYPE.m_6215_(name).get()));
        }
        return fixedBlock;
    }

    public static void addVerticalSlabPair(ImmutableBiMap.Builder<Block, Block> builder, Supplier<Block> altered) {
        String name = Utils.getID((Block)altered.get()).m_135815_();
        name = name.replace("cracked_", "");
        ResourceLocation res = new ResourceLocation("quark", name = name.replace("mossy_", ""));
        if (ForgeRegistries.BLOCKS.containsKey(res)) {
            builder.put((Object)((Block)ForgeRegistries.BLOCKS.getValue(res)), (Object)altered.get());
        } else {
            res = new ResourceLocation("minecraft", name);
            if (ForgeRegistries.BLOCKS.containsKey(res)) {
                builder.put((Object)((Block)ForgeRegistries.BLOCKS.getValue(res)), (Object)altered.get());
            }
        }
    }

    public static boolean isVerticalSlabsOn() {
        return ModuleLoader.INSTANCE.isModuleEnabled(VerticalSlabsModule.class);
    }
}

