/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.forge;

import com.ordana.immersive_weathering.data.block_growths.BlockGrowthHandler;
import com.ordana.immersive_weathering.data.fluid_generators.FluidGeneratorsHandler;
import com.ordana.immersive_weathering.events.ModEvents;
import com.ordana.immersive_weathering.events.ModLootInjects;
import net.minecraft.world.InteractionResult;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immersive_weathering", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    @SubscribeEvent
    public static void onTagUpdated(TagsUpdatedEvent event) {
        BlockGrowthHandler.RELOAD_INSTANCE.rebuild(event.getRegistryAccess());
        FluidGeneratorsHandler.RELOAD_INSTANCE.rebuild(event.getRegistryAccess());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult ret = ModEvents.onBlockCLicked(event.getItemStack(), event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
        if (ret != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(ret);
        }
    }

    @SubscribeEvent
    public static void onAddLootTables(LootTableLoadEvent event) {
        ModLootInjects.onLootInject(event.getLootTableManager(), event.getName(), b -> event.getTable().addPool(b.m_79082_()));
    }
}

