/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.rute_tests;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.data.block_growths.Operator;
import com.ordana.immersive_weathering.reg.ModRuleTests;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTestType;
import org.jetbrains.annotations.Nullable;

public class BlockPropertyTest
extends RuleTest {
    public static final Codec<BlockPropertyTest> CODEC = PropPredicate.CODEC.listOf().fieldOf("properties").xmap(BlockPropertyTest::new, t -> t.propPredicates).codec();
    private final List<PropPredicate> propPredicates;

    private BlockPropertyTest(List<PropPredicate> propPredicates) {
        this.propPredicates = propPredicates;
    }

    public boolean m_213865_(BlockState state, RandomSource random) {
        for (PropPredicate p : this.propPredicates) {
            if (p.test(state)) continue;
            return false;
        }
        return true;
    }

    protected RuleTestType<BlockPropertyTest> m_7319_() {
        return ModRuleTests.BLOCK_PROPERTY_TEST.get();
    }

    protected static Codec<Comparable<?>> valueCodec(Property<?> property) {
        return Codec.STRING.flatXmap(string -> property.m_6215_(string).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown Property value" + string + " in " + property))), value -> DataResult.success((Object)value.toString()));
    }

    protected static Codec<Property<? extends Comparable<?>>> propertyCodec(BlockState state) {
        return Codec.STRING.flatXmap(string -> {
            for (Property p : state.m_61147_()) {
                if (!p.m_61708_().equals(string)) continue;
                return DataResult.success((Object)p);
            }
            return DataResult.error((String)("Unknown Property " + string + " in " + state));
        }, property1 -> DataResult.success((Object)property1.m_61708_()));
    }

    private static final class PropPredicate
    implements Predicate<BlockState> {
        public static Codec<PropPredicate> CODEC = Registry.f_122824_.m_194605_().partialDispatch("from_block", b -> DataResult.success((Object)b.getFromBlock()), block -> {
            BlockState state = block.m_49966_();
            if (state.m_61148_().isEmpty()) {
                return DataResult.error((String)"Target Block has no properties");
            }
            Codec c = BlockPropertyTest.propertyCodec(state).partialDispatch("property", b -> DataResult.success(b.getProperty()), property -> {
                Codec c1 = RecordCodecBuilder.create(i -> i.group((App)BlockPropertyTest.valueCodec(property).optionalFieldOf("value").forGetter(PropPredicate::getTargetValue), (App)Operator.CODEC.optionalFieldOf("operator", (Object)Operator.EQUAL).forGetter(PropPredicate::getOperator)).apply((Applicative)i, (v, o) -> new PropPredicate((Block)block, (Property<?>)property, (Optional<Comparable<?>>)v, (Operator)((Object)((Object)((Object)((Object)o)))))));
                return DataResult.success((Object)c1);
            });
            return DataResult.success((Object)c);
        });
        private final Block fromBlock;
        private final Property<?> property;
        private final Operator operator;
        @Nullable
        private final Comparable<?> targetValue;
        private final Integer intValue;

        public PropPredicate(Block fromBlock, Property<?> property, Optional<Comparable<?>> value, Operator operator) {
            Integer i;
            Comparable<?> comparable;
            this.property = property;
            this.targetValue = value.orElse(null);
            this.fromBlock = fromBlock;
            this.operator = operator;
            this.intValue = property instanceof IntegerProperty && operator != null && (comparable = this.targetValue) instanceof Integer ? (i = (Integer)comparable) : null;
        }

        public Block getFromBlock() {
            return this.fromBlock;
        }

        public Optional<Comparable<?>> getTargetValue() {
            return Optional.ofNullable(this.targetValue);
        }

        public Property<?> getProperty() {
            return this.property;
        }

        public Operator getOperator() {
            return this.operator;
        }

        @Override
        public boolean test(BlockState state) {
            Optional val = state.m_61145_(this.property);
            if (val.isPresent()) {
                if (this.intValue != null) {
                    return this.operator.apply((Integer)val.get(), this.intValue);
                }
                return this.targetValue == null || val.get() == this.targetValue;
            }
            return false;
        }
    }
}

