/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.position_tests;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.data.position_tests.IPositionRuleTest;
import com.ordana.immersive_weathering.mixins.accessors.BiomeAccessor;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

record TemperatureMatchTest(float max, float min, boolean useLocalPos) implements IPositionRuleTest
{
    public static final String NAME = "temperature_range";
    private static final Codec<TemperatureMatchTest> C = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("min").forGetter(g -> Float.valueOf(g.min)), (App)Codec.FLOAT.fieldOf("max").forGetter(g -> Float.valueOf(g.max)), (App)Codec.BOOL.optionalFieldOf("use_local_pos", (Object)true).forGetter(TemperatureMatchTest::useLocalPos)).apply((Applicative)instance, TemperatureMatchTest::new)).comapFlatMap(t -> {
        if (t.max < t.min) {
            return DataResult.error((String)("Max must be at least min, min_inclusive: " + t.min + ", max_inclusive: " + t.max));
        }
        return DataResult.success((Object)t);
    }, Function.identity());
    static final IPositionRuleTest.Type<TemperatureMatchTest> TYPE = new IPositionRuleTest.Type<TemperatureMatchTest>(C, "temperature_range");

    public IPositionRuleTest.Type<TemperatureMatchTest> getType() {
        return TYPE;
    }

    @Override
    public boolean test(Supplier<Holder<Biome>> biome, BlockPos pos, Level level) {
        float temp = level.m_6042_().f_63857_() ? 3.0f : (this.useLocalPos ? ((BiomeAccessor)biome.get().m_203334_()).invokeGetTemperature(pos) : ((Biome)biome.get().m_203334_()).m_47554_());
        return temp >= this.min && temp <= this.max;
    }
}

