/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.position_tests;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.data.position_tests.IPositionRuleTest;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

record PrecipitationTest(Biome.Precipitation precipitation) implements IPositionRuleTest
{
    public static final String NAME = "precipitation_test";
    public static final Codec<PrecipitationTest> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Biome.Precipitation.f_47717_.fieldOf("precipitation").forGetter(PrecipitationTest::precipitation)).apply((Applicative)instance, PrecipitationTest::new));
    static final IPositionRuleTest.Type<PrecipitationTest> TYPE = new IPositionRuleTest.Type<PrecipitationTest>(CODEC, "precipitation_test");

    public IPositionRuleTest.Type<PrecipitationTest> getType() {
        return TYPE;
    }

    @Override
    public boolean test(Supplier<Holder<Biome>> biome, BlockPos pos, Level level) {
        block5: for (Direction d : Direction.values()) {
            if (d == Direction.DOWN) continue;
            switch (this.precipitation) {
                case NONE: {
                    if (!level.m_46758_(pos.m_121945_(d))) continue block5;
                    return false;
                }
                case SNOW: {
                    if (!level.m_46758_(pos.m_121945_(d)) || !((Biome)biome.get().m_203334_()).m_198904_(pos.m_121945_(d))) continue block5;
                    return true;
                }
                case RAIN: {
                    if (!level.m_46758_(pos.m_121945_(d)) || !((Biome)biome.get().m_203334_()).m_198906_(pos.m_121945_(d))) continue block5;
                    return true;
                }
            }
        }
        return this.precipitation == Biome.Precipitation.NONE;
    }
}

