/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.fluid_generators;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.data.fluid_generators.IFluidGenerator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class FluidGeneratorsHandler
extends SimpleJsonResourceReloadListener {
    public static final ImmutableList<Direction> POSSIBLE_FLOW_DIRECTIONS = ImmutableList.of((Object)Direction.DOWN, (Object)Direction.SOUTH, (Object)Direction.NORTH, (Object)Direction.EAST, (Object)Direction.WEST);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final FluidGeneratorsHandler RELOAD_INSTANCE = new FluidGeneratorsHandler();
    private static final Map<ResourceLocation, JsonElement> TO_PARSE = new HashMap<ResourceLocation, JsonElement>();
    private static final Map<Fluid, ImmutableList<IFluidGenerator>> STILL_GENERATORS = new Object2ObjectOpenHashMap();
    private static final Map<Fluid, ImmutableList<IFluidGenerator>> FLOWING_GENERATORS = new Object2ObjectOpenHashMap();
    private static final Set<Fluid> HAS_GENERATOR = new HashSet<Fluid>();
    private boolean needsRefresh;

    public FluidGeneratorsHandler() {
        super(GSON, "fluid_generators");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager manager, ProfilerFiller profile) {
        this.needsRefresh = true;
        TO_PARSE.clear();
        for (Map.Entry<ResourceLocation, JsonElement> e : jsons.entrySet()) {
            TO_PARSE.put(e.getKey(), e.getValue().deepCopy());
        }
    }

    public void rebuild(RegistryAccess registryAccess) {
        if (this.needsRefresh) {
            this.needsRefresh = false;
            ArrayList generators = new ArrayList();
            for (Map.Entry<ResourceLocation, JsonElement> e2 : TO_PARSE.entrySet()) {
                JsonElement json = e2.getValue();
                DataResult result = IFluidGenerator.CODEC.parse((DynamicOps)RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registryAccess), (Object)json);
                Optional o = result.resultOrPartial(error -> ImmersiveWeathering.LOGGER.error("Failed to read liquid generator JSON object for {} : {}", e2.getKey(), error));
                o.ifPresent(generators::add);
            }
            ImmersiveWeathering.LOGGER.info("Loaded {} liquid generators configurations", (Object)TO_PARSE.size());
            STILL_GENERATORS.clear();
            FLOWING_GENERATORS.clear();
            HAS_GENERATOR.clear();
            HashMap<Fluid, List> flowingMap = new HashMap<Fluid, List>();
            HashMap<Fluid, List> stillMap = new HashMap<Fluid, List>();
            for (IFluidGenerator g : generators) {
                List list;
                HAS_GENERATOR.add(g.getFluid());
                if (g.getFluidType().isFlowing()) {
                    list = flowingMap.computeIfAbsent(g.getFluid(), e -> new ArrayList());
                    list.add(g);
                    Collections.sort(list);
                }
                if (!g.getFluidType().isStill()) continue;
                list = stillMap.computeIfAbsent(g.getFluid(), e -> new ArrayList());
                list.add(g);
                Collections.sort(list);
            }
            flowingMap.forEach((key, value) -> FLOWING_GENERATORS.put((Fluid)key, (ImmutableList<IFluidGenerator>)ImmutableList.copyOf((Collection)value)));
            stillMap.forEach((key, value) -> STILL_GENERATORS.put((Fluid)key, (ImmutableList<IFluidGenerator>)ImmutableList.copyOf((Collection)value)));
            TO_PARSE.clear();
        }
    }

    public static Optional<Pair<BlockPos, @Nullable SoundEvent>> applyGenerators(FlowingFluid fluid, List<Direction> possibleFlowDir, BlockPos pos, Level level) {
        Fluid source = fluid.m_5613_();
        if (HAS_GENERATOR.contains(source)) {
            ImmutableList<IFluidGenerator> list = level.m_6425_(pos).m_76170_() ? STILL_GENERATORS.get(source) : FLOWING_GENERATORS.get(source);
            return FluidGeneratorsHandler.generate(possibleFlowDir, pos, level, list);
        }
        return Optional.empty();
    }

    private static Optional<Pair<BlockPos, @Nullable SoundEvent>> generate(List<Direction> possibleFlowDir, BlockPos pos, Level level, ImmutableList<IFluidGenerator> list) {
        if (list != null && !list.isEmpty()) {
            EnumMap<Direction, BlockState> neighborCache = new EnumMap<Direction, BlockState>(Direction.class);
            for (IFluidGenerator generator : list) {
                Optional<BlockPos> res = generator.tryGenerating(possibleFlowDir, pos, level, neighborCache);
                if (!res.isPresent()) continue;
                return res.map(a -> Pair.of((Object)a, (Object)generator.getSound()));
            }
        }
        return Optional.empty();
    }

    public void saveGeneartor(IFluidGenerator song) {
        File folder = PlatformHelper.getGamePath().resolve("test").toFile();
        if (!folder.exists()) {
            folder.mkdir();
        }
        File exportPath = new File(folder, "template.json");
        try (FileWriter writer = new FileWriter(exportPath);){
            this.writeToFile(song, writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeToFile(IFluidGenerator obj, FileWriter writer) {
        DataResult r = IFluidGenerator.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)obj);
        r.result().ifPresent(a -> GSON.toJson((JsonElement)this.sortJson(a.getAsJsonObject()), (Appendable)writer));
    }

    private JsonObject sortJson(JsonObject jsonObject) {
        try {
            TreeMap<String, JsonElement> joToMap = new TreeMap<String, JsonElement>();
            jsonObject.entrySet().forEach(e -> {
                JsonElement j = (JsonElement)e.getValue();
                if (j instanceof JsonObject) {
                    JsonObject jo = (JsonObject)j;
                    j = this.sortJson(jo);
                }
                joToMap.put((String)e.getKey(), j);
            });
            JsonObject sortedJSON = new JsonObject();
            joToMap.forEach((arg_0, arg_1) -> ((JsonObject)sortedJSON).add(arg_0, arg_1));
            return sortedJSON;
        }
        catch (Exception exception) {
            return jsonObject;
        }
    }
}

