/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths.growths.builtin;

import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.blocks.LeafPileBlock;
import com.ordana.immersive_weathering.configs.ClientConfigs;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.data.block_growths.TickSource;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.BuiltinBlockGrowth;
import com.ordana.immersive_weathering.network.NetworkHandler;
import com.ordana.immersive_weathering.network.SendCustomParticlesPacket;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.util.WeatheringHelper;
import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class LeavesGrowth
extends BuiltinBlockGrowth {
    public LeavesGrowth(String name, @Nullable HolderSet<Block> owners, List<TickSource> sources, float chance) {
        super(name, owners, sources, chance);
    }

    @Override
    public void tryGrowing(BlockPos pos, BlockState state, ServerLevel level, Supplier<Holder<Biome>> biome) {
        Block leafPile;
        if (this.growthChance != 1.0f && !(level.f_46441_.m_188501_() < this.growthChance)) {
            return;
        }
        RandomSource random = level.f_46441_;
        if ((!state.m_61138_((Property)LeavesBlock.f_54419_) || !((Boolean)state.m_61143_((Property)LeavesBlock.f_54419_)).booleanValue()) && random.m_188501_() < (float)CommonConfigs.LEAF_PILES_REACH.get().intValue() && (leafPile = (Block)WeatheringHelper.getFallenLeafPile(state).orElse(null)) != null && level.m_8055_(pos.m_7495_()).m_60795_()) {
            if (random.m_188499_() && WeatheringHelper.isIciclePos(pos) && ((Biome)level.m_204166_(pos).m_203334_()).m_198904_(pos)) {
                level.m_7731_(pos.m_7495_(), (BlockState)ModBlocks.ICICLE.get().m_49966_().m_61124_((Property)PointedDripstoneBlock.f_154009_, (Comparable)Direction.DOWN), 2);
            }
            if (!PlatformHelper.isAreaLoaded((LevelReader)level, (BlockPos)pos, (int)2)) {
                return;
            }
            BlockPos targetPos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos);
            int maxFallenLeavesReach = CommonConfigs.LEAF_PILES_REACH.get();
            int maxPileHeight = CommonConfigs.LEAF_PILE_MAX_HEIGHT.get();
            int dist = pos.m_123342_() - targetPos.m_123342_();
            if (dist < 0) {
                BlockState selected;
                targetPos = pos;
                do {
                    targetPos = targetPos.m_7495_();
                    dist = pos.m_123342_() - targetPos.m_123342_();
                } while ((selected = level.m_8055_(targetPos)).m_60767_().m_76336_() && selected.m_60819_().m_76178_() && dist < maxFallenLeavesReach);
                targetPos = targetPos.m_7494_();
            }
            if (dist < maxFallenLeavesReach) {
                this.tryPlacingAt(level, leafPile, targetPos, maxPileHeight);
            }
        }
    }

    private void tryPlacingAt(ServerLevel level, Block leafPile, BlockPos targetPos, int maxPileHeight) {
        BlockState replaceState = level.m_8055_(targetPos);
        BlockState groundState = level.m_8055_(targetPos.m_7495_());
        boolean isOnLeaf = replaceState.m_60734_() instanceof LeafPileBlock;
        boolean waterBelow = groundState.m_60713_(Blocks.f_49990_) && groundState.m_60819_().m_76170_();
        int pileHeight = 1;
        if (isOnLeaf && ((pileHeight = ((Integer)replaceState.m_61143_((Property)LeafPileBlock.LAYERS)).intValue()) == 0 || pileHeight >= maxPileHeight)) {
            return;
        }
        BlockState baseLeaf = (BlockState)leafPile.m_49966_().m_61124_((Property)LeafPileBlock.LAYERS, (Comparable)Integer.valueOf(waterBelow ? 0 : 1));
        if (isOnLeaf || replaceState.m_60767_().m_76336_() && baseLeaf.m_60710_((LevelReader)level, targetPos) && !WeatheringHelper.hasEnoughBlocksAround(targetPos, 2, 1, 2, (Level)level, b -> b.m_60734_() instanceof LeafPileBlock, 5)) {
            if (waterBelow) {
                level.m_7731_(targetPos, baseLeaf, 2);
            } else {
                if (isOnLeaf) {
                    int original = pileHeight;
                    boolean hasLog = false;
                    BlockState[] neighbors = new BlockState[4];
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        neighbors[direction.m_122416_()] = level.m_8055_(targetPos.m_121945_(direction));
                    }
                    for (BlockState neighbor : neighbors) {
                        if (!WeatheringHelper.isLog(neighbor)) continue;
                        hasLog = true;
                        break;
                    }
                    for (BlockState neighbor : neighbors) {
                        int i;
                        if (!(neighbor.m_60734_() instanceof LeafPileBlock)) continue;
                        int n = i = hasLog ? maxPileHeight : Math.min((Integer)neighbor.m_61143_((Property)LeafPileBlock.LAYERS) - 1, maxPileHeight);
                        if (i <= pileHeight) continue;
                        pileHeight = Math.min(pileHeight + 1, i);
                        break;
                    }
                    if (pileHeight == original) {
                        return;
                    }
                }
                level.m_7731_(targetPos, (BlockState)baseLeaf.m_61124_((Property)LeafPileBlock.LAYERS, (Comparable)Integer.valueOf(pileHeight)), 2);
            }
        }
    }

    public static void spawnFallingLeavesParticle(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!(state.m_60734_() instanceof LeavesBlock)) {
            return;
        }
        if (ClientConfigs.FALLING_LEAF_PARTICLES.get().booleanValue() && !((Boolean)state.m_61143_((Property)LeavesBlock.f_54419_)).booleanValue()) {
            SimpleParticleType leafParticle = WeatheringHelper.getFallenLeafParticle(state).orElse(null);
            if (leafParticle == null) {
                return;
            }
            int color = Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)level, pos, 0);
            BlockPos blockPos = pos.m_7495_();
            BlockState blockState = level.m_8055_(blockPos);
            if (!blockState.m_60815_() || !blockState.m_60838_((BlockGetter)level, blockPos)) {
                double rate = ClientConfigs.FALLING_LEAF_PARTICLE_RATE.get();
                if (level.m_46471_()) {
                    rate = ClientConfigs.RAINY_FALLING_LEAF_PARTICLE_RATE.get();
                }
                if (level.m_46470_()) {
                    rate = ClientConfigs.STORMY_FALLING_LEAF_PARTICLE_RATE.get();
                }
                if ((double)random.m_188501_() < rate) {
                    double d = (double)pos.m_123341_() + random.m_188500_();
                    double e = (double)pos.m_123342_() - 0.05;
                    double f = (double)pos.m_123343_() + random.m_188500_();
                    level.m_7106_((ParticleOptions)leafParticle, d, e, f, 0.0, (double)color, 0.0);
                }
            }
        }
    }

    public static void decayLeavesPile(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos downPos;
        BlockState downState;
        if (!(state.m_60734_() instanceof LeavesBlock)) {
            ImmersiveWeathering.LOGGER.error("Some mod tried to call leaves random tick without passing a leaf block blockstate as expected. This should be fixed on their end. Given blockstate : {}", (Object)state);
            return;
        }
        if (CommonConfigs.LEAF_PILES_FROM_DECAY_CHANCE.get() > (double)level.f_46441_.m_188501_()) {
            Block leafPile = WeatheringHelper.getFallenLeafPile(state).orElse(null);
            if (leafPile == null) {
                return;
            }
            BlockState baseLeaf = leafPile.m_49966_();
            level.m_7731_(pos, (BlockState)baseLeaf.m_61124_((Property)LeafPileBlock.LAYERS, (Comparable)Integer.valueOf(Mth.m_216287_((RandomSource)level.f_46441_, (int)1, (int)5))), 2);
        }
        if (!(downState = level.m_8055_(downPos = pos.m_7495_())).m_60815_() || !downState.m_60783_((BlockGetter)level, downPos, Direction.UP)) {
            NetworkHandler.CHANNEL.sendToAllClientPlayersInRange((Level)level, pos, 32.0, (Message)new SendCustomParticlesPacket(SendCustomParticlesPacket.EventType.DECAY_LEAVES, pos, Block.m_49956_((BlockState)state)));
        }
    }
}

