/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths.growths.builtin;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.data.block_growths.TickSource;
import com.ordana.immersive_weathering.data.block_growths.growths.IBlockGrowth;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.BuiltinGrowthsRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public abstract class BuiltinBlockGrowth
implements IBlockGrowth {
    public static final Codec<BuiltinBlockGrowth> CODEC = Codec.STRING.partialDispatch("builtin", b -> DataResult.success((Object)b.getName()), n -> {
        BuiltinGrowthsRegistry.BuiltinGrowthFactory factory = BuiltinGrowthsRegistry.BUILTIN_GROWTHS.get(n);
        if (factory == null) {
            return DataResult.error((String)("No builtin growth found with id " + n));
        }
        Codec codec = RecordCodecBuilder.create(i -> i.group((App)TickSource.CODEC.listOf().optionalFieldOf("tick_sources", List.of(TickSource.BLOCK_TICK)).forGetter(b -> b.sources), (App)RegistryCodecs.m_206277_((ResourceKey)Registry.f_122901_).optionalFieldOf("owners").forGetter(b -> Optional.ofNullable(b.owners)), (App)Codec.FLOAT.optionalFieldOf("growth_chance", (Object)Float.valueOf(1.0f)).forGetter(b -> Float.valueOf(b.growthChance))).apply((Applicative)i, (o, s, c) -> factory.create((String)n, (HolderSet<Block>)((HolderSet)s.orElse(null)), (List<TickSource>)o, c.floatValue())));
        return DataResult.success((Object)codec);
    });
    private final HolderSet<Block> owners;
    private final String name;
    private final List<TickSource> sources;
    protected final float growthChance;

    protected BuiltinBlockGrowth(String name, @Nullable HolderSet<Block> owners, List<TickSource> sources, float chance) {
        this.owners = owners;
        this.name = name;
        this.sources = sources;
        this.growthChance = chance;
    }

    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Iterable<? extends Block> getOwners() {
        if (this.owners == null) {
            return null;
        }
        return this.owners.m_203614_().map(Holder::m_203334_).toList();
    }

    @Override
    public final Collection<TickSource> getTickSources() {
        return this.sources;
    }
}

