/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.client;

import com.ordana.immersive_weathering.IWPlatformStuff;
import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.client.particles.EmberParticle;
import com.ordana.immersive_weathering.client.particles.LeafParticle;
import com.ordana.immersive_weathering.items.FlowerCrownItem;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModEntities;
import com.ordana.immersive_weathering.reg.ModItems;
import com.ordana.immersive_weathering.reg.ModParticles;
import net.mehvahdjukaar.moonlight.api.client.renderer.FallingBlockRendererGeneric;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.GlowParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ImmersiveWeatheringClient {
    public static void init() {
        ClientPlatformHelper.addEntityRenderersRegistration(ImmersiveWeatheringClient::registerEntityRenderers);
        ClientPlatformHelper.addBlockColorsRegistration(ImmersiveWeatheringClient::registerBlockColors);
        ClientPlatformHelper.addItemColorsRegistration(ImmersiveWeatheringClient::registerItemColors);
        ClientPlatformHelper.addParticleRegistration(ImmersiveWeatheringClient::registerParticles);
    }

    public static void setup() {
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.ROOTED_GRASS_BLOCK.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)Blocks.f_50079_, (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)Blocks.f_50647_, (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)Blocks.f_50633_, (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)Blocks.f_50275_, (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)Blocks.f_50177_, (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)Blocks.f_50223_, (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)Blocks.f_50645_, (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)Blocks.f_50631_, (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)Blocks.f_50607_, (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.MOSSY_BRICKS.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.MOSSY_BRICK_SLAB.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.MOSSY_BRICK_STAIRS.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.MOSSY_BRICK_WALL.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.MOSSY_STONE.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.MOSSY_STONE_SLAB.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.MOSSY_STONE_STAIRS.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.MOSSY_STONE_WALL.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.VITRIFIED_SAND.get(), (RenderType)RenderType.m_110466_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.EXPOSED_IRON_DOOR.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.WEATHERED_IRON_DOOR.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.RUSTED_IRON_DOOR.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.EXPOSED_IRON_TRAPDOOR.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.WEATHERED_IRON_TRAPDOOR.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.RUSTED_IRON_TRAPDOOR.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.EXPOSED_IRON_BARS.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.WEATHERED_IRON_BARS.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.RUSTED_IRON_BARS.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.WAXED_IRON_DOOR.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.WAXED_EXPOSED_IRON_DOOR.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.WAXED_WEATHERED_IRON_DOOR.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.WAXED_RUSTED_IRON_DOOR.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.WAXED_IRON_TRAPDOOR.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.WAXED_EXPOSED_IRON_TRAPDOOR.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.WAXED_WEATHERED_IRON_TRAPDOOR.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.WAXED_RUSTED_IRON_TRAPDOOR.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.WAXED_IRON_BARS.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.WAXED_EXPOSED_IRON_BARS.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.WAXED_WEATHERED_IRON_BARS.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.WAXED_RUSTED_IRON_BARS.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.ICICLE.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.FULGURITE.get(), (RenderType)RenderType.m_110463_());
        ModBlocks.LEAF_PILES.values().forEach(b -> ClientPlatformHelper.registerRenderType((Block)b, (RenderType)RenderType.m_110463_()));
        ClientPlatformHelper.registerRenderType((Block)((Block)ModBlocks.AZALEA_FLOWER_PILE.get()), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.WEEDS.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)((Block)ModBlocks.IVY.get()), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.MOSS.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.SOOT.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.SOOT.get(), (RenderType)RenderType.m_110466_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.FROST.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.FROST.get(), (RenderType)RenderType.m_110466_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.FROSTY_GLASS.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.FROSTY_GLASS.get(), (RenderType)RenderType.m_110466_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.FROSTY_GLASS_PANE.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.FROSTY_GLASS_PANE.get(), (RenderType)RenderType.m_110466_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.FROSTY_GRASS.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.FROSTY_FERN.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.THIN_ICE.get(), (RenderType)RenderType.m_110466_());
        ClientPlatformHelper.registerRenderType((Block)ModBlocks.HANGING_ROOTS_WALL.get(), (RenderType)RenderType.m_110463_());
        ClientPlatformHelper.registerItemProperty((Item)ModItems.FLOWER_CROWN.get(), (ResourceLocation)ImmersiveWeathering.res("supporter"), (stack, world, entity, s) -> FlowerCrownItem.getItemTextureIndex(stack));
    }

    private static void registerEntityRenderers(ClientPlatformHelper.EntityRendererEvent event) {
        event.register(ModEntities.FALLING_ICICLE.get(), FallingBlockRendererGeneric::new);
        event.register(ModEntities.FALLING_LAYER.get(), FallingBlockRendererGeneric::new);
        event.register(ModEntities.FALLING_PROPAGULE.get(), FallingBlockRendererGeneric::new);
    }

    private static void registerParticles(ClientPlatformHelper.ParticleEvent event) {
        event.register((ParticleType)ModParticles.EMBERSPARK.get(), EmberParticle.EmberFactory::new);
        event.register((ParticleType)ModParticles.EMBER.get(), EmberParticle.EmberFactory::new);
        event.register((ParticleType)ModParticles.SOOT.get(), LeafParticle.SimpleLeafParticle::new);
        ModParticles.FALLING_LEAVES_PARTICLES.forEach((t, p) -> {
            if (t.id.m_135815_().contains("azalea")) {
                event.register((ParticleType)p, LeafParticle.SimpleLeafParticle::new);
            } else {
                event.register((ParticleType)p, LeafParticle.ColoredLeafParticle::new);
            }
        });
        event.register((ParticleType)ModParticles.AZALEA_FLOWER.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.MULCH.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.NULCH.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.SCRAPE_RUST.get(), ScrapeRustFactory::new);
        event.register((ParticleType)ModParticles.OAK_BARK.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.BIRCH_BARK.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.SPRUCE_BARK.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.DARK_OAK_BARK.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.JUNGLE_BARK.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.ACACIA_BARK.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.MANGROVE_BARK.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.NETHER_SCALE.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.MOSS.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_BEE.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_JAR.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_BOB.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_ACE.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_ARO.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_BI.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_ENBY.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_GAY.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_LESBIAN.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_RAINBOW.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_TRANS.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_GENDERQUEER.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_FLUID.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_INTERSEX.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_PAN.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_FLAX.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_NEKOMASTER.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_AKASHII.get(), LeafParticle.SimpleLeafParticle::new);
    }

    private static void registerBlockColors(ClientPlatformHelper.BlockColorEvent event) {
        BlockColor defaultGrassColor = (state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.m_46415_((double)0.0, (double)0.0);
        BlockColor defaultFoliageColor = (state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)world, (BlockPos)pos) : FoliageColor.m_46113_();
        ModBlocks.LEAF_PILES.forEach((type, leafPile) -> {
            Block leaf = type.leaves;
            if (leaf == Blocks.f_50052_) {
                IWPlatformStuff.copyColorFrom(event, (Block)leafPile, leaf, (state, world, pos, tintIndex) -> FoliageColor.m_46112_());
            } else if (leaf == Blocks.f_50051_) {
                IWPlatformStuff.copyColorFrom(event, (Block)leafPile, leaf, (state, world, pos, tintIndex) -> FoliageColor.m_46106_());
            } else {
                if (leaf == Blocks.f_152470_ || leaf == Blocks.f_152471_) {
                    return;
                }
                IWPlatformStuff.copyColorFrom(event, (Block)leafPile, leaf, defaultFoliageColor);
            }
        });
        IWPlatformStuff.copyColorFrom(event, ModBlocks.FROSTY_GRASS.get(), Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, ModBlocks.FROSTY_FERN.get(), Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, ModBlocks.ROOTED_GRASS_BLOCK.get(), Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, ModBlocks.MOSSY_BRICKS.get(), Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, ModBlocks.MOSSY_BRICK_SLAB.get(), Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, ModBlocks.MOSSY_BRICK_STAIRS.get(), Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, ModBlocks.MOSSY_BRICK_WALL.get(), Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, ModBlocks.MOSSY_STONE.get(), Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, ModBlocks.MOSSY_STONE_SLAB.get(), Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, ModBlocks.MOSSY_STONE_STAIRS.get(), Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, ModBlocks.MOSSY_STONE_WALL.get(), Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, Blocks.f_50079_, Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, Blocks.f_50647_, Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, Blocks.f_50633_, Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, Blocks.f_50275_, Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, Blocks.f_50177_, Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, Blocks.f_50223_, Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, Blocks.f_50645_, Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, Blocks.f_50631_, Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, Blocks.f_50607_, Blocks.f_50440_, defaultGrassColor);
    }

    private static void registerItemColors(ClientPlatformHelper.ItemColorEvent event) {
        ItemColor defaultGrassColor = (stack, tintIndex) -> GrassColor.m_46415_((double)0.5, (double)0.5);
        IWPlatformStuff.copyColorFrom(event, (ItemLike)ModBlocks.ROOTED_GRASS_BLOCK.get(), (ItemLike)Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, (ItemLike)Items.f_41998_, (ItemLike)Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, (ItemLike)Items.f_42331_, (ItemLike)Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, (ItemLike)Items.f_42369_, (ItemLike)Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, (ItemLike)Items.f_42067_, (ItemLike)Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, (ItemLike)Items.f_42015_, (ItemLike)Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, (ItemLike)Items.f_42019_, (ItemLike)Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, (ItemLike)Items.f_42381_, (ItemLike)Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, (ItemLike)Items.f_42367_, (ItemLike)Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, (ItemLike)Items.f_42071_, (ItemLike)Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, (ItemLike)ModBlocks.MOSSY_BRICKS.get(), (ItemLike)Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, (ItemLike)ModBlocks.MOSSY_BRICK_SLAB.get(), (ItemLike)Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, (ItemLike)ModBlocks.MOSSY_BRICK_STAIRS.get(), (ItemLike)Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, (ItemLike)ModBlocks.MOSSY_BRICK_WALL.get(), (ItemLike)Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, (ItemLike)ModBlocks.MOSSY_STONE.get(), (ItemLike)Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, (ItemLike)ModBlocks.MOSSY_STONE_SLAB.get(), (ItemLike)Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, (ItemLike)ModBlocks.MOSSY_STONE_STAIRS.get(), (ItemLike)Blocks.f_50440_, defaultGrassColor);
        IWPlatformStuff.copyColorFrom(event, (ItemLike)ModBlocks.MOSSY_STONE_WALL.get(), (ItemLike)Blocks.f_50440_, defaultGrassColor);
        ItemColor defaultFoliageColor = (stack, tintIndex) -> FoliageColor.m_46113_();
        ModItems.LEAF_PILES.forEach((type, leafPile) -> {
            Block leaf = type.leaves;
            if (leaf == Blocks.f_50052_) {
                IWPlatformStuff.copyColorFrom(event, (ItemLike)leafPile, (ItemLike)leaf, (s, i) -> FoliageColor.m_46112_());
            } else if (leaf == Blocks.f_50051_) {
                IWPlatformStuff.copyColorFrom(event, (ItemLike)leafPile, (ItemLike)leaf, (s, tintIndex) -> FoliageColor.m_46106_());
            } else {
                IWPlatformStuff.copyColorFrom(event, (ItemLike)leafPile, (ItemLike)leaf, defaultFoliageColor);
            }
        });
    }

    private static class ScrapeRustFactory
    extends GlowParticle.ScrapeProvider {
        public ScrapeRustFactory(SpriteSet spriteSet) {
            super(spriteSet);
        }

        public Particle m_6966_(SimpleParticleType particleType, ClientLevel level, double p_172207_, double p_172208_, double p_172209_, double p_172210_, double p_172211_, double p_172212_) {
            Particle p = super.m_6966_(particleType, level, p_172207_, p_172208_, p_172209_, p_172210_, p_172211_, p_172212_);
            if (p != null) {
                if (level.f_46441_.m_188499_()) {
                    p.m_107253_(0.76862746f, 0.4627451f, 0.28627452f);
                } else {
                    p.m_107253_(0.6901961f, 0.24705882f, 0.15686275f);
                }
            }
            return p;
        }
    }
}

