/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.soil;

import com.ordana.immersive_weathering.blocks.ModBlockProperties;
import com.ordana.immersive_weathering.data.block_growths.IConditionalGrowingBlock;
import com.ordana.immersive_weathering.reg.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class SoilBlock
extends SnowyDirtBlock
implements BonemealableBlock,
IConditionalGrowingBlock {
    public static final BooleanProperty FERTILE = ModBlockProperties.FERTILE;

    public SoilBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FERTILE, (Comparable)Boolean.valueOf(true)));
    }

    public static boolean isFertile(BlockState state) {
        return state.m_61138_((Property)FERTILE) && (Boolean)state.m_61143_((Property)FERTILE) != false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FERTILE});
    }

    public boolean m_6724_(BlockState state) {
        return SoilBlock.isFertile(state) && super.m_6724_(state);
    }

    @Override
    public boolean canGrow(BlockState state) {
        return SoilBlock.isFertile(state);
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        return !SoilBlock.isFertile(state) && level.m_8055_(pos.m_7494_()).m_60795_();
    }

    public boolean m_214167_(Level p_50901_, RandomSource p_50902_, BlockPos p_50903_, BlockState p_50904_) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (!SoilBlock.isFertile(state)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)FERTILE, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof ShearsItem && !((Boolean)state.m_61143_((Property)f_56637_)).booleanValue() && ((Boolean)state.m_61143_((Property)FERTILE)).booleanValue()) {
            level.m_5594_(player, pos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
            stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(hand));
            level.m_142052_(pos, state);
            if (player instanceof ServerPlayer) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)FERTILE, (Comparable)Boolean.FALSE));
                level.m_142346_((Entity)player, GameEvent.f_157781_, pos);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (item instanceof ShovelItem && !((Boolean)state.m_61143_((Property)f_56637_)).booleanValue() && !state.m_60713_(ModBlocks.SILT.get())) {
            level.m_5594_(player, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(hand));
            if (player instanceof ServerPlayer) {
                level.m_46597_(pos, Blocks.f_152481_.m_49966_());
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }
}

