/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.soil;

import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MulchBlock
extends FarmBlock {
    public MulchBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return true;
    }

    public boolean m_7923_(BlockState state) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!this.isSoaked(state) || random.m_188503_(25) != 1 || (blockstate = level.m_8055_(blockpos = pos.m_7495_())).m_60815_() && blockstate.m_60783_((BlockGetter)level, blockpos, Direction.UP))) {
            double d0 = (double)pos.m_123341_() + random.m_188500_();
            double d1 = (double)pos.m_123342_() - 0.05;
            double d2 = (double)pos.m_123343_() + random.m_188500_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123803_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState cropState = level.m_8055_(pos.m_7494_());
        if (CommonConfigs.MULCH_GROWS_CROPS.get().booleanValue() && level.m_45524_(pos.m_7494_(), 0) >= 9 && (Integer)state.m_61143_((Property)f_53243_) == 7) {
            Block block;
            if (CommonConfigs.MULCH_GROWTH_TYPE_RANDOM_TICK.get().booleanValue() || cropState.m_60734_() instanceof StemBlock) {
                for (int i = 0; i < CommonConfigs.MULCH_GROWTH_RANDOM_TICKS.get(); ++i) {
                    cropState.m_222972_(level, pos.m_7494_(), random);
                }
            } else if (CommonConfigs.MULCH_GROWTH_TYPE_BONEMEAL.get().booleanValue() && (block = cropState.m_60734_()) instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                crop.m_52263_((Level)level, pos.m_7494_(), cropState);
            }
        }
        int temperature = 0;
        boolean isTouchingWater = false;
        for (Direction direction : Direction.values()) {
            BlockPos targetPos = pos.m_121945_(direction);
            Holder biome = level.m_204166_(pos);
            BlockState neighborState = level.m_8055_(targetPos);
            if (neighborState.m_60819_().m_205070_(FluidTags.f_13131_)) {
                isTouchingWater = true;
            }
            if (level.m_46758_(pos.m_121945_(direction)) || biome.m_203656_(ModTags.WET) || neighborState.m_60819_().m_205070_(FluidTags.f_13131_)) {
                --temperature;
                continue;
            }
            if (!neighborState.m_204336_(ModTags.MAGMA_SOURCE) && !biome.m_203565_(Biomes.f_48203_) && level.m_46472_() != Level.f_46429_) continue;
            ++temperature;
        }
        if (temperature < 0 || isTouchingWater) {
            if ((Integer)state.m_61143_((Property)f_53243_) == 0) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(7)));
            }
        } else if (temperature > 0 && this.isSoaked(state)) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(0)));
        }
    }

    private boolean isSoaked(BlockState state) {
        return (Integer)state.m_61143_((Property)f_53243_) == 7;
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        entity.m_142535_(fallDistance, 0.2f, DamageSource.f_19315_);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_36341_()) {
            if (player.m_21120_(hand).m_150930_(Items.f_42447_) && !this.isSoaked(state)) {
                if (!player.m_7500_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                }
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(7)));
                level.m_5594_(player, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123769_, (IntProvider)UniformInt.m_146622_((int)3, (int)5));
                return InteractionResult.SUCCESS;
            }
            if (player.m_21120_(hand).m_150930_(Items.f_42446_) && this.isSoaked(state)) {
                if (!player.m_7500_()) {
                    ItemStack stack = player.m_21120_(hand);
                    ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)Items.f_42447_.m_7968_());
                    player.m_21008_(hand, itemStack2);
                }
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(0)));
                level.m_5594_(player, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123769_, (IntProvider)UniformInt.m_146622_((int)3, (int)5));
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }
}

