/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.soil;

import com.ordana.immersive_weathering.blocks.ModBlockProperties;
import com.ordana.immersive_weathering.blocks.soil.SoilBlock;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.data.block_growths.IConditionalGrowingBlock;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class ModGrassBlock
extends GrassBlock
implements BonemealableBlock,
IConditionalGrowingBlock {
    public static final BooleanProperty FERTILE = SoilBlock.FERTILE;
    public static final IntegerProperty AGE = ModBlockProperties.AGE;

    public ModGrassBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FERTILE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FERTILE});
        builder.m_61104_(new Property[]{AGE});
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        super.m_141947_(level, pos, state, entity);
        RandomSource random = level.m_213780_();
        if (CommonConfigs.DESIRE_PATHS.get().booleanValue()) {
            int j = (Integer)state.m_61143_((Property)AGE);
            if (entity instanceof Player || entity.m_6095_().m_204039_(ModTags.TRAMPLES_PATHS)) {
                double rarity = CommonConfigs.DESIRE_PATH_RATE.get();
                if ((double)random.m_188501_() < rarity && (Integer)state.m_61143_((Property)AGE) < 10) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(j + 1)), 3);
                }
            }
        }
    }

    public boolean m_6724_(BlockState state) {
        return SoilBlock.isFertile(state) && super.m_6724_(state);
    }

    @Override
    public boolean canGrow(BlockState state) {
        return SoilBlock.isFertile(state);
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (!SoilBlock.isFertile(state)) {
            state = (BlockState)state.m_61124_((Property)FERTILE, (Comparable)Boolean.valueOf(true));
            level.m_7731_(pos, state, 3);
        } else {
            super.m_214148_(level, random, pos, state);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemstack;
        if (SoilBlock.isFertile(state) && (itemstack = player.m_21120_(hand)).m_41720_() instanceof ShearsItem) {
            if (!level.f_46443_) {
                level.m_5594_(null, pos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)FERTILE, (Comparable)Boolean.valueOf(false)), 11);
                itemstack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(hand));
                level.m_142346_((Entity)player, GameEvent.f_157781_, pos);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)Items.f_42574_));
            } else {
                level.m_142052_(pos, Blocks.f_50034_.m_49966_());
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213898_(state, level, pos, random);
        if (level.m_8055_(pos) != state) {
            return;
        }
        if ((Integer)state.m_61143_((Property)AGE) == 10) {
            level.m_46597_(pos, Blocks.f_152481_.m_49966_());
            return;
        }
        if ((Integer)state.m_61143_((Property)AGE) < 10 && (Integer)state.m_61143_((Property)AGE) > 1) {
            int j = (Integer)state.m_61143_((Property)AGE);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(j - 1)), 3);
            return;
        }
        if (level.m_46803_(pos.m_7494_()) >= 9) {
            BlockState blockState = this.m_49966_();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockPos = pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(5) - 3, random.m_188503_(3) - 1);
                BlockState s = level.m_8055_(blockPos);
                if (CommonConfigs.GRASS_OVER_MYCELIUM.get().booleanValue() && s.m_60713_(Blocks.f_50195_) && ModGrassBlock.m_56827_((BlockState)blockState, (LevelReader)level, (BlockPos)blockPos)) {
                    level.m_46597_(blockPos, (BlockState)this.m_49966_().m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(level.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_50125_))));
                    continue;
                }
                if (!s.m_60713_(Blocks.f_152549_) || !ModGrassBlock.m_56827_((BlockState)blockState, (LevelReader)level, (BlockPos)blockPos)) continue;
                level.m_46597_(blockPos, (BlockState)ModBlocks.ROOTED_GRASS_BLOCK.get().m_49966_().m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(level.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_50125_))));
            }
        }
    }
}

