/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.rustable;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModTags;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.state.BlockState;

public interface Rustable
extends ChangeOverTimeBlock<RustLevel> {
    public static final Supplier<BiMap<Block, Block>> RUST_LEVEL_INCREASES = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)ModBlocks.CUT_IRON.get(), (Object)ModBlocks.EXPOSED_CUT_IRON.get()).put((Object)ModBlocks.EXPOSED_CUT_IRON.get(), (Object)ModBlocks.WEATHERED_CUT_IRON.get()).put((Object)ModBlocks.WEATHERED_CUT_IRON.get(), (Object)ModBlocks.RUSTED_CUT_IRON.get()).put((Object)ModBlocks.CUT_IRON_SLAB.get(), (Object)ModBlocks.EXPOSED_CUT_IRON_SLAB.get()).put((Object)ModBlocks.EXPOSED_CUT_IRON_SLAB.get(), (Object)ModBlocks.WEATHERED_CUT_IRON_SLAB.get()).put((Object)ModBlocks.WEATHERED_CUT_IRON_SLAB.get(), (Object)ModBlocks.RUSTED_CUT_IRON_SLAB.get()).put((Object)ModBlocks.CUT_IRON_STAIRS.get(), (Object)ModBlocks.EXPOSED_CUT_IRON_STAIRS.get()).put((Object)ModBlocks.EXPOSED_CUT_IRON_STAIRS.get(), (Object)ModBlocks.WEATHERED_CUT_IRON_STAIRS.get()).put((Object)ModBlocks.WEATHERED_CUT_IRON_STAIRS.get(), (Object)ModBlocks.RUSTED_CUT_IRON_STAIRS.get()).put((Object)ModBlocks.PLATE_IRON.get(), (Object)ModBlocks.EXPOSED_PLATE_IRON.get()).put((Object)ModBlocks.EXPOSED_PLATE_IRON.get(), (Object)ModBlocks.WEATHERED_PLATE_IRON.get()).put((Object)ModBlocks.WEATHERED_PLATE_IRON.get(), (Object)ModBlocks.RUSTED_PLATE_IRON.get()).put((Object)ModBlocks.PLATE_IRON_SLAB.get(), (Object)ModBlocks.EXPOSED_PLATE_IRON_SLAB.get()).put((Object)ModBlocks.EXPOSED_PLATE_IRON_SLAB.get(), (Object)ModBlocks.WEATHERED_PLATE_IRON_SLAB.get()).put((Object)ModBlocks.WEATHERED_PLATE_IRON_SLAB.get(), (Object)ModBlocks.RUSTED_PLATE_IRON_SLAB.get()).put((Object)ModBlocks.PLATE_IRON_STAIRS.get(), (Object)ModBlocks.EXPOSED_PLATE_IRON_STAIRS.get()).put((Object)ModBlocks.EXPOSED_PLATE_IRON_STAIRS.get(), (Object)ModBlocks.WEATHERED_PLATE_IRON_STAIRS.get()).put((Object)ModBlocks.WEATHERED_PLATE_IRON_STAIRS.get(), (Object)ModBlocks.RUSTED_PLATE_IRON_STAIRS.get()).put((Object)Blocks.f_50166_, (Object)ModBlocks.EXPOSED_IRON_DOOR.get()).put((Object)ModBlocks.EXPOSED_IRON_DOOR.get(), (Object)ModBlocks.WEATHERED_IRON_DOOR.get()).put((Object)ModBlocks.WEATHERED_IRON_DOOR.get(), (Object)ModBlocks.RUSTED_IRON_DOOR.get()).put((Object)Blocks.f_50376_, (Object)ModBlocks.EXPOSED_IRON_TRAPDOOR.get()).put((Object)ModBlocks.EXPOSED_IRON_TRAPDOOR.get(), (Object)ModBlocks.WEATHERED_IRON_TRAPDOOR.get()).put((Object)ModBlocks.WEATHERED_IRON_TRAPDOOR.get(), (Object)ModBlocks.RUSTED_IRON_TRAPDOOR.get()).put((Object)Blocks.f_50183_, (Object)ModBlocks.EXPOSED_IRON_BARS.get()).put((Object)ModBlocks.EXPOSED_IRON_BARS.get(), (Object)ModBlocks.WEATHERED_IRON_BARS.get()).put((Object)ModBlocks.WEATHERED_IRON_BARS.get(), (Object)ModBlocks.RUSTED_IRON_BARS.get()).put((Object)ModBlocks.CUT_IRON_VERTICAL_SLAB.get(), (Object)ModBlocks.EXPOSED_CUT_IRON_VERTICAL_SLAB.get()).put((Object)ModBlocks.EXPOSED_CUT_IRON_VERTICAL_SLAB.get(), (Object)ModBlocks.WEATHERED_CUT_IRON_VERTICAL_SLAB.get()).put((Object)ModBlocks.WEATHERED_CUT_IRON_VERTICAL_SLAB.get(), (Object)ModBlocks.RUSTED_CUT_IRON_VERTICAL_SLAB.get()).put((Object)ModBlocks.PLATE_IRON_VERTICAL_SLAB.get(), (Object)ModBlocks.EXPOSED_PLATE_IRON_VERTICAL_SLAB.get()).put((Object)ModBlocks.EXPOSED_PLATE_IRON_VERTICAL_SLAB.get(), (Object)ModBlocks.WEATHERED_PLATE_IRON_VERTICAL_SLAB.get()).put((Object)ModBlocks.WEATHERED_PLATE_IRON_VERTICAL_SLAB.get(), (Object)ModBlocks.RUSTED_PLATE_IRON_VERTICAL_SLAB.get()).build());
    public static final Supplier<BiMap<Block, Block>> RUST_LEVEL_DECREASES = Suppliers.memoize(() -> RUST_LEVEL_INCREASES.get().inverse());

    public static Optional<Block> getDecreasedRustBlock(Block block) {
        return Optional.ofNullable((Block)RUST_LEVEL_DECREASES.get().get((Object)block));
    }

    public static Block getUnaffectedRustBlock(Block block) {
        Block block2 = block;
        Block block3 = (Block)RUST_LEVEL_DECREASES.get().get((Object)block2);
        while (block3 != null) {
            block2 = block3;
            block3 = (Block)RUST_LEVEL_DECREASES.get().get((Object)block2);
        }
        return block2;
    }

    default public Optional<BlockState> getPrevious(BlockState state) {
        return Rustable.getDecreasedRustBlock(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    public static Optional<Block> getIncreasedRustBlock(Block block) {
        return Optional.ofNullable((Block)RUST_LEVEL_INCREASES.get().get((Object)block));
    }

    public static BlockState getUnaffectedRustState(BlockState state) {
        return Rustable.getUnaffectedRustBlock(state.m_60734_()).m_152465_(state);
    }

    default public Optional<BlockState> m_142123_(BlockState state) {
        return Rustable.getIncreasedRustBlock(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    default public float m_142377_() {
        if (this.m_142297_() == RustLevel.UNAFFECTED) {
            return 0.75f;
        }
        return 1.0f;
    }

    default public int getInfluenceRadius() {
        return CommonConfigs.RUSTING_INFLUENCE_RADIUS.get();
    }

    default public void m_220952_(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource randomSource) {
        BlockPos blockpos;
        int distance;
        int age = ((RustLevel)this.m_142297_()).ordinal();
        int j = 0;
        int k = 0;
        int affectingDistance = this.getInfluenceRadius();
        Iterator iterator = BlockPos.m_121925_((BlockPos)pos, (int)affectingDistance, (int)affectingDistance, (int)affectingDistance).iterator();
        while (iterator.hasNext() && (distance = (blockpos = (BlockPos)iterator.next()).m_123333_((Vec3i)pos)) <= affectingDistance) {
            BlockState blockstate;
            Block block;
            if (blockpos.equals((Object)pos) || !((block = (blockstate = serverLevel.m_8055_(blockpos)).m_60734_()) instanceof ChangeOverTimeBlock)) continue;
            ChangeOverTimeBlock changeOverTimeBlock = (ChangeOverTimeBlock)block;
            Enum ageEnum = changeOverTimeBlock.m_142297_();
            if (((Object)((Object)((RustLevel)this.m_142297_()))).getClass() != ageEnum.getClass()) continue;
            int neighbourAge = ageEnum.ordinal();
            if (neighbourAge < age) {
                return;
            }
            if (neighbourAge > age) {
                ++k;
                continue;
            }
            ++j;
        }
        float f = (float)(k + 1) / (float)(k + j + 1);
        float f1 = f * f * this.m_142377_();
        if (randomSource.m_188501_() < f1) {
            this.m_142123_(state).ifPresent(s -> serverLevel.m_46597_(pos, s));
        }
    }

    default public void tryWeather(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.m_204336_(ModTags.RUSTED_IRON)) {
            boolean canWeather = false;
            for (Direction direction : Direction.values()) {
                BlockPos targetPos = pos.m_121945_(direction);
                BlockState neighborState = world.m_8055_(targetPos);
                if (neighborState.m_60713_(Blocks.f_50628_) && (double)random.m_188501_() < CommonConfigs.RUSTING_RATE.get()) {
                    canWeather = true;
                    continue;
                }
                if (neighborState.m_60819_().m_205070_(FluidTags.f_13131_) && (double)random.m_188501_() < CommonConfigs.RUSTING_RATE.get() / 1.25) {
                    canWeather = true;
                    continue;
                }
                if (state.m_204336_(ModTags.CLEAN_IRON)) {
                    if (!neighborState.m_60713_(Blocks.f_50016_) || !((double)random.m_188501_() < CommonConfigs.RUSTING_RATE.get() / 5.0)) continue;
                    canWeather = true;
                    continue;
                }
                if (!state.m_204336_(ModTags.EXPOSED_IRON) && (!state.m_204336_(ModTags.CLEAN_IRON) || !world.m_46471_() || !((double)random.m_188501_() < CommonConfigs.RUSTING_RATE.get() / 2.0))) continue;
                if (world.m_46758_(pos.m_7494_())) {
                    canWeather = true;
                    continue;
                }
                if (!CommonConfigs.RUST_STREAKING.get().booleanValue() || !world.m_46758_(targetPos) || !world.m_8055_(pos.m_7494_()).m_204336_(ModTags.WEATHERED_IRON) || !((double)random.m_188501_() < CommonConfigs.RUSTING_RATE.get() / 3.0)) continue;
                if (BlockPos.m_121985_((BlockPos)pos, (int)2, (int)2, (int)2).map(arg_0 -> ((ServerLevel)world).m_8055_(arg_0)).filter(b -> b.m_204336_(ModTags.WEATHERED_IRON)).toList().size() > 9) continue;
                canWeather = true;
            }
            if (canWeather) {
                this.m_220952_(state, world, pos, random);
            }
        }
    }

    public static enum RustLevel {
        UNAFFECTED,
        EXPOSED,
        WEATHERED,
        RUSTED;


        public boolean canScrape() {
            return this != WEATHERED && this != RUSTED;
        }
    }
}

