/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.rustable;

import com.ordana.immersive_weathering.blocks.rustable.Rustable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class RustAffectedTrapdoorBlock
extends TrapDoorBlock {
    private final Rustable.RustLevel rustLevel;

    public RustAffectedTrapdoorBlock(Rustable.RustLevel rustLevel, BlockBehaviour.Properties settings) {
        super(settings);
        this.rustLevel = rustLevel;
    }

    public void playOpenCloseSound(Level world, BlockPos pos, boolean open) {
        world.m_5898_(null, open ? 1011 : 1006, pos, 0);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        boolean hasPower = world.m_46753_(pos);
        if (hasPower != (Boolean)state.m_61143_((Property)f_57516_)) {
            switch (this.getAge()) {
                case UNAFFECTED: {
                    if (this.m_49966_().m_60713_(block) || hasPower == (Boolean)state.m_61143_((Property)f_57516_)) break;
                    if (hasPower != (Boolean)state.m_61143_((Property)f_57514_)) {
                        this.playOpenCloseSound(world, pos, hasPower);
                        world.m_142346_(null, hasPower ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
                    }
                    world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)f_57516_, (Comparable)Boolean.valueOf(hasPower))).m_61124_((Property)f_57514_, (Comparable)Boolean.valueOf(hasPower)), 2);
                    break;
                }
                case EXPOSED: {
                    if (hasPower) {
                        world.m_186460_(pos, (Block)this, 1);
                    } else {
                        world.m_186460_(pos, (Block)this, 10);
                    }
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_57516_, (Comparable)Boolean.valueOf(hasPower)), 2);
                    break;
                }
                case WEATHERED: {
                    if (hasPower) {
                        world.m_186460_(pos, (Block)this, 1);
                    } else {
                        world.m_186460_(pos, (Block)this, 20);
                    }
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_57516_, (Comparable)Boolean.valueOf(hasPower)), 2);
                    break;
                }
                case RUSTED: {
                    if (hasPower && !((Boolean)state.m_61143_((Property)f_57516_)).booleanValue()) {
                        state = (BlockState)state.m_61122_((Property)f_57514_);
                        this.playOpenCloseSound(world, pos, (Boolean)state.m_61143_((Property)f_57514_));
                        world.m_142346_(null, (Boolean)state.m_61143_((Property)f_57514_) != false ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
                    }
                    world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)f_57516_, (Comparable)Boolean.valueOf(hasPower))).m_61124_((Property)f_57514_, (Comparable)((Boolean)state.m_61143_((Property)f_57514_))), 2);
                }
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (this.getAge() == Rustable.RustLevel.EXPOSED || this.getAge() == Rustable.RustLevel.WEATHERED) {
            state = (BlockState)state.m_61122_((Property)f_57514_);
            this.playOpenCloseSound((Level)world, pos, (Boolean)state.m_61143_((Property)f_57514_));
            world.m_142346_(null, (Boolean)state.m_61143_((Property)f_57514_) != false ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_57514_, (Comparable)((Boolean)state.m_61143_((Property)f_57514_))), 2);
        }
    }

    public boolean m_6724_(BlockState state) {
        return false;
    }

    public Rustable.RustLevel getAge() {
        return this.rustLevel;
    }
}

