/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.rustable;

import com.ordana.immersive_weathering.blocks.rustable.Rustable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class RustAffectedDoorBlock
extends DoorBlock {
    private final Rustable.RustLevel rustLevel;

    public RustAffectedDoorBlock(Rustable.RustLevel rustLevel, BlockBehaviour.Properties settings) {
        super(settings);
        this.rustLevel = rustLevel;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.m_61143_((Property)f_52730_);
        if ((direction == Direction.UP && doubleBlockHalf == DoubleBlockHalf.LOWER || direction == Direction.DOWN && doubleBlockHalf == DoubleBlockHalf.UPPER) && neighborState.m_60734_() instanceof RustAffectedDoorBlock) {
            state = neighborState.m_60734_().m_152465_(state);
        }
        if (direction.m_122434_() == Direction.Axis.Y && doubleBlockHalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return neighborState.m_60713_(state.m_60734_()) && neighborState.m_61143_((Property)f_52730_) != doubleBlockHalf ? (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)f_52726_, (Comparable)((Direction)neighborState.m_61143_((Property)f_52726_)))).m_61124_((Property)f_52727_, (Comparable)((Boolean)neighborState.m_61143_((Property)f_52727_)))).m_61124_((Property)f_52728_, (Comparable)((DoorHingeSide)neighborState.m_61143_((Property)f_52728_)))).m_61124_((Property)f_52729_, (Comparable)((Boolean)neighborState.m_61143_((Property)f_52729_))) : Blocks.f_50016_.m_49966_();
        }
        return doubleBlockHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : state;
    }

    public void playSound(Level world, BlockPos pos, boolean open) {
        world.m_5898_(null, open ? 1011 : 1005, pos, 0);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        boolean hasPower;
        boolean bl = world.m_46753_(pos) || world.m_46753_(pos.m_121945_(state.m_61143_((Property)f_52730_) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN)) ? true : (hasPower = false);
        if (hasPower != (Boolean)state.m_61143_((Property)f_52729_) && this != block) {
            switch (this.getAge()) {
                case UNAFFECTED: {
                    if (hasPower != (Boolean)state.m_61143_((Property)f_52727_)) {
                        this.playSound(world, pos, hasPower);
                        world.m_142346_(null, hasPower ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
                    }
                    world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(hasPower))).m_61124_((Property)f_52727_, (Comparable)Boolean.valueOf(hasPower)), 2);
                    break;
                }
                case EXPOSED: {
                    if (hasPower) {
                        world.m_186460_(pos, (Block)this, 1);
                    } else {
                        world.m_186460_(pos, (Block)this, 10);
                    }
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(hasPower)), 2);
                    break;
                }
                case WEATHERED: {
                    if (hasPower) {
                        world.m_186460_(pos, (Block)this, 1);
                    } else {
                        world.m_186460_(pos, (Block)this, 20);
                    }
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(hasPower)), 2);
                    break;
                }
                case RUSTED: {
                    if (hasPower && !((Boolean)state.m_61143_((Property)f_52729_)).booleanValue()) {
                        state = (BlockState)state.m_61122_((Property)f_52727_);
                        this.playSound(world, pos, (Boolean)state.m_61143_((Property)f_52727_));
                        world.m_142346_(null, (Boolean)state.m_61143_((Property)f_52727_) != false ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
                    }
                    world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)f_52729_, (Comparable)Boolean.valueOf(hasPower))).m_61124_((Property)f_52727_, (Comparable)((Boolean)state.m_61143_((Property)f_52727_))), 2);
                }
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (this.getAge() == Rustable.RustLevel.EXPOSED || this.getAge() == Rustable.RustLevel.WEATHERED) {
            state = (BlockState)state.m_61122_((Property)f_52727_);
            this.playSound((Level)world, pos, (Boolean)state.m_61143_((Property)f_52727_));
            world.m_142346_(null, (Boolean)state.m_61143_((Property)f_52727_) != false ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_52727_, (Comparable)((Boolean)state.m_61143_((Property)f_52727_))), 2);
        }
    }

    public boolean m_6724_(BlockState state) {
        return false;
    }

    public Rustable.RustLevel getAge() {
        return this.rustLevel;
    }
}

