/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.mossable;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.ordana.immersive_weathering.IWPlatformStuff;
import com.ordana.immersive_weathering.blocks.PatchSpreader;
import com.ordana.immersive_weathering.blocks.Weatherable;
import com.ordana.immersive_weathering.blocks.mossable.MossSpreader;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.util.WeatheringHelper;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public interface Mossable
extends Weatherable {
    public static final Supplier<BiMap<Block, Block>> MOSS_LEVEL_INCREASES = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)Blocks.f_50069_, (Object)ModBlocks.MOSSY_STONE.get()).put((Object)Blocks.f_50635_, (Object)ModBlocks.MOSSY_STONE_STAIRS.get()).put((Object)Blocks.f_50404_, (Object)ModBlocks.MOSSY_STONE_SLAB.get()).put((Object)Blocks.f_50652_, (Object)Blocks.f_50079_).put((Object)ModBlocks.STONE_WALL.get(), (Object)ModBlocks.MOSSY_STONE_WALL.get()).put((Object)Blocks.f_50157_, (Object)Blocks.f_50633_).put((Object)Blocks.f_50409_, (Object)Blocks.f_50647_).put((Object)Blocks.f_50274_, (Object)Blocks.f_50275_).put((Object)Blocks.f_50222_, (Object)Blocks.f_50223_).put((Object)Blocks.f_50225_, (Object)ModBlocks.MOSSY_CHISELED_STONE_BRICKS.get()).put((Object)Blocks.f_50194_, (Object)Blocks.f_50631_).put((Object)Blocks.f_50411_, (Object)Blocks.f_50645_).put((Object)Blocks.f_50609_, (Object)Blocks.f_50607_).put((Object)Blocks.f_50076_, (Object)ModBlocks.MOSSY_BRICKS.get()).put((Object)Blocks.f_50193_, (Object)ModBlocks.MOSSY_BRICK_STAIRS.get()).put((Object)Blocks.f_50410_, (Object)ModBlocks.MOSSY_BRICK_SLAB.get()).put((Object)Blocks.f_50604_, (Object)ModBlocks.MOSSY_BRICK_WALL.get());
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "quark:vertical_brick_slab", "immersive_weathering:vertical_mossy_brick_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "quark:vertical_cobblestone_slab", "quark:vertical_mossy_cobblestone_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "quark:vertical_stone_brick_slab", "quark:vertical_mossy_stone_brick_slab");
        WeatheringHelper.addOptional((ImmutableBiMap.Builder<Block, Block>)builder, "immersive_weathering:vertical_stone_slab", "immersive_weathering:vertical_mossy_stone_slab");
        IWPlatformStuff.addExtraMossyBlocks((ImmutableBiMap.Builder<Block, Block>)builder);
        return builder.build();
    });
    public static final Supplier<BiMap<Block, Block>> MOSS_LEVEL_DECREASES = Suppliers.memoize(() -> MOSS_LEVEL_INCREASES.get().inverse());

    public static BlockState getUnaffectedMossBlock(BlockState state) {
        Block block2 = state.m_60734_();
        Block block3 = (Block)MOSS_LEVEL_DECREASES.get().get((Object)block2);
        while (block3 != null) {
            block2 = block3;
            block3 = (Block)MOSS_LEVEL_DECREASES.get().get((Object)block2);
        }
        return block2.m_152465_(state);
    }

    public static BlockState getMossyBlock(BlockState state) {
        Block block2 = state.m_60734_();
        Block block3 = (Block)MOSS_LEVEL_INCREASES.get().get((Object)block2);
        while (block3 != null) {
            block2 = block3;
            block3 = (Block)MOSS_LEVEL_INCREASES.get().get((Object)block2);
        }
        return block2.m_152465_(state);
    }

    public static Optional<Block> getDecreasedMossBlock(Block block) {
        return Optional.ofNullable((Block)MOSS_LEVEL_DECREASES.get().get((Object)block));
    }

    public static Optional<Block> getIncreasedMossBlock(Block block) {
        return Optional.ofNullable((Block)MOSS_LEVEL_INCREASES.get().get((Object)block));
    }

    default public Optional<BlockState> getNextMossy(BlockState state) {
        return Mossable.getIncreasedMossBlock(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    default public Optional<BlockState> getPreviousMossy(BlockState state) {
        return Mossable.getDecreasedMossBlock(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    public MossSpreader getMossSpreader();

    @Override
    default public <T extends Enum<?>> Optional<PatchSpreader<T>> getPatchSpreader(Class<T> weatheringClass) {
        if (weatheringClass == MossLevel.class) {
            return Optional.of(this.getMossSpreader());
        }
        return Optional.empty();
    }

    @Override
    default public boolean shouldWeather(BlockState state, BlockPos pos, Level level) {
        if (!CommonConfigs.MOSS_SPREADING_ENABLED.get().booleanValue()) {
            return false;
        }
        return this.getMossSpreader().getWantedWeatheringState(false, pos, level);
    }

    public MossLevel getMossLevel();

    @Override
    public boolean isWeathering(BlockState var1);

    @Override
    default public void tryWeather(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource random) {
        if (random.m_188501_() < this.getWeatherChanceSpeed()) {
            BlockState newState;
            Optional<BlockState> opt = Optional.empty();
            if (this.getMossSpreader().getWantedWeatheringState(true, pos, (Level)serverLevel)) {
                opt = this.getNextMossy(state);
            }
            if ((newState = opt.orElse((BlockState)state.m_61124_(Weatherable.WEATHERABLE, (Comparable)((Object)Weatherable.WeatheringState.FALSE)))) != state) {
                serverLevel.m_7731_(pos, newState, 2);
                if (!newState.m_61138_(Weatherable.WEATHERABLE)) {
                    serverLevel.m_186460_(pos, state.m_60734_(), 1);
                }
            }
        }
    }

    public static enum MossLevel {
        UNAFFECTED,
        MOSSY;

    }
}

