/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.mossable;

import com.ordana.immersive_weathering.blocks.PatchSpreader;
import com.ordana.immersive_weathering.blocks.Weatherable;
import com.ordana.immersive_weathering.blocks.crackable.Crackable;
import com.ordana.immersive_weathering.blocks.mossable.Mossable;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public interface CrackableMossable
extends Mossable,
Crackable {
    @Override
    default public <T extends Enum<?>> Optional<PatchSpreader<T>> getPatchSpreader(Class<T> weatheringClass) {
        if (weatheringClass == Mossable.MossLevel.class) {
            return Optional.of(this.getMossSpreader());
        }
        if (weatheringClass == Crackable.CrackLevel.class) {
            return Optional.of(this.getCrackSpreader());
        }
        return Optional.empty();
    }

    @Override
    default public boolean shouldWeather(BlockState state, BlockPos pos, Level level) {
        return Mossable.super.shouldWeather(state, pos, level) || Crackable.super.shouldWeather(state, pos, level);
    }

    @Override
    default public void tryWeather(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource random) {
        if (random.m_188501_() < this.getWeatherChanceSpeed()) {
            boolean isMoss = this.getMossSpreader().getWantedWeatheringState(true, pos, (Level)serverLevel);
            Optional<Object> opt = Optional.empty();
            if (isMoss) {
                opt = this.getNextMossy(state);
            } else if (this.getCrackSpreader().getWantedWeatheringState(true, pos, (Level)serverLevel)) {
                opt = this.getNextCracked(state);
            }
            BlockState newState = opt.orElse((BlockState)state.m_61124_(Weatherable.WEATHERABLE, (Comparable)((Object)Weatherable.WeatheringState.FALSE)));
            if (newState != state) {
                serverLevel.m_7731_(pos, newState, 2);
                if (!newState.m_61138_(Weatherable.WEATHERABLE)) {
                    serverLevel.m_186460_(pos, state.m_60734_(), 1);
                }
            }
        }
    }
}

