/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks;

import com.ordana.immersive_weathering.blocks.PatchSpreader;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;

public interface Weatherable {
    public static final EnumProperty<WeatheringState> WEATHERABLE = EnumProperty.m_61587_((String)"weathering", WeatheringState.class);

    public boolean shouldWeather(BlockState var1, BlockPos var2, Level var3);

    public boolean isWeathering(BlockState var1);

    public <T extends Enum<?>> Optional<PatchSpreader<T>> getPatchSpreader(Class<T> var1);

    default public float getWeatherChanceSpeed() {
        return 0.1f;
    }

    public void tryWeather(BlockState var1, ServerLevel var2, BlockPos var3, RandomSource var4);

    default public BlockState getWeatheredStateForPlacement(BlockState state, BlockPos pos, Level level) {
        if (state != null) {
            WeatheringState weathering;
            WeatheringState weatheringState = weathering = this.shouldWeather(state, pos, level) ? WeatheringState.TRUE : WeatheringState.FALSE;
            if (state.m_61138_(WEATHERABLE)) {
                state = (BlockState)state.m_61124_(WEATHERABLE, (Comparable)((Object)weathering));
            }
        }
        return state;
    }

    default public void updateWeatheredStateOnNeighborChanged(BlockState state, Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            WeatheringState current = (WeatheringState)((Object)state.m_61143_(WEATHERABLE));
            if (!current.isStable()) {
                WeatheringState wantedState;
                WeatheringState weatheringState = wantedState = this.shouldWeather(state, pos, (Level)serverLevel) ? WeatheringState.TRUE : WeatheringState.FALSE;
                if (state.m_61143_(WEATHERABLE) != wantedState) {
                    serverLevel.m_7731_(pos, (BlockState)state.m_61124_(WEATHERABLE, (Comparable)((Object)wantedState)), 2);
                    if (wantedState == WeatheringState.TRUE) {
                        level.m_186460_(pos, state.m_60734_(), 1);
                    }
                }
            }
        }
    }

    public static BlockState setStable(BlockState state) {
        if (state.m_61138_(WEATHERABLE)) {
            state = (BlockState)state.m_61124_(WEATHERABLE, (Comparable)((Object)WeatheringState.STABLE));
        }
        return state;
    }

    public static enum WeatheringState implements StringRepresentable
    {
        FALSE,
        TRUE,
        STABLE;


        public boolean isWeathering() {
            return this == TRUE;
        }

        public boolean isStable() {
            return this == STABLE;
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

