/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks;

import com.ordana.immersive_weathering.entities.FallingPropaguleEntity;
import com.ordana.immersive_weathering.reg.ModTags;
import com.ordana.immersive_weathering.util.WeatheringHelper;
import java.util.Random;
import javax.swing.text.html.BlockView;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.MangrovePropaguleBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;

public class ModPropaguleBlock
extends MangrovePropaguleBlock
implements Fallable {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public ModPropaguleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean notify) {
        level.m_186460_(pos, (Block)this, this.getFallDelay());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        } else if ((!((Boolean)state.m_61143_((Property)f_221443_)).booleanValue() || ((Boolean)state.m_61143_((Property)f_221443_)).booleanValue() && (Integer)state.m_61143_((Property)f_221441_) < 4) && !state.m_60710_((LevelReader)level, pos)) {
            level.m_7471_(pos, true);
        }
        level.m_186460_(pos, (Block)this, this.getFallDelay());
        return state;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (ModPropaguleBlock.canFallThrough(level.m_8055_(pos.m_7495_())) && pos.m_123342_() >= level.m_141937_() && (level.m_8055_(pos.m_7494_()).m_60795_() || level.m_8055_(pos.m_7494_()).m_204336_(ModTags.LEAF_PILES)) && ((Boolean)state.m_61143_((Property)f_221443_)).booleanValue() && (Integer)state.m_61143_((Property)f_221441_) == 4) {
            FallingPropaguleEntity fallingblockentity = FallingPropaguleEntity.fall((Level)level, pos, state);
            this.configureFallingBlockEntity((FallingBlockEntity)fallingblockentity);
        }
    }

    protected void configureFallingBlockEntity(FallingBlockEntity entity) {
    }

    protected int getFallDelay() {
        return 2;
    }

    public static boolean canFallThrough(BlockState state) {
        Material material = state.m_60767_();
        return state.m_60795_() || state.m_204336_(BlockTags.f_13076_) || material.m_76332_() || material.m_76336_();
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, Random random) {
        BlockPos blockPos;
        if (random.nextInt(16) == 0 && ModPropaguleBlock.canFallThrough(level.m_8055_(blockPos = pos.m_7495_()))) {
            double d = (double)pos.m_123341_() + random.nextDouble();
            double e = (double)pos.m_123342_() - 0.05;
            double f = (double)pos.m_123343_() + random.nextDouble();
            SimpleParticleType leafParticle = WeatheringHelper.getFallenLeafParticle(Blocks.f_220838_.m_49966_()).orElse(null);
            assert (leafParticle != null);
            level.m_7106_((ParticleOptions)leafParticle, d, e, f, 0.0, 0.0, 0.0);
        }
    }

    public int color(BlockState state, BlockView level, BlockPos pos) {
        return -16777216;
    }
}

