/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks;

import com.ordana.immersive_weathering.blocks.LayerBlock;
import com.ordana.immersive_weathering.blocks.ModBlockProperties;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.entities.FallingLayerEntity;
import com.ordana.immersive_weathering.reg.ModParticles;
import com.ordana.immersive_weathering.reg.ModTags;
import com.ordana.immersive_weathering.util.WeatheringHelper;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LeafPileBlock
extends LayerBlock
implements BonemealableBlock {
    private static final int FIRE_SPREAD = 30;
    private static final int FLAMMABILITY = 60;
    public static final IntegerProperty LAYERS = ModBlockProperties.LEAF_LAYERS;
    private static final VoxelShape[] SHAPE_BY_LAYER_L = new VoxelShape[9];
    private static final float[] COLLISIONS;
    private final boolean canBeBonemealed;
    private final boolean hasThorns;
    private final List<Supplier<SimpleParticleType>> particles;
    private final LeavesType leafType;

    public LeafPileBlock(BlockBehaviour.Properties settings, LeavesType leafType) {
        super(settings);
        this.leafType = leafType;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1)));
        String name = leafType.id.m_135815_();
        this.canBeBonemealed = name.contains("flower");
        this.hasThorns = name.equals("spruce");
        this.particles = List.of(() -> ModParticles.FALLING_LEAVES_PARTICLES.get(leafType));
        RegHelper.registerBlockFlammability((Block)this, (int)30, (int)60);
    }

    public LeavesType getLeafType() {
        return this.leafType;
    }

    @PlatformOnly(value={"forge"})
    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }

    @Override
    public int getLayers(BlockState state) {
        return (Integer)state.m_61143_((Property)LAYERS);
    }

    @Override
    public IntegerProperty layerProperty() {
        return LAYERS;
    }

    public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1;
    }

    @Override
    public VoxelShape getDefaultShape(BlockState state) {
        return SHAPE_BY_LAYER_L[(Integer)state.m_61143_((Property)LAYERS)];
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        int layers = this.getLayers(state);
        if (layers > 3 && CommonConfigs.LEAF_PILES_SLOW.get().booleanValue() && entity instanceof LivingEntity && !(entity instanceof Fox) && !(entity instanceof Bee) && EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44973_, (LivingEntity)((LivingEntity)entity)) <= 0) {
            Player player;
            float stuck = COLLISIONS[Math.max(0, layers - 1)];
            entity.m_7601_(state, new Vec3((double)stuck, 1.0, (double)stuck));
            if (!(layers < 6 || !this.hasThorns || level.f_46443_ || entity.f_19790_ == entity.m_20185_() && entity.f_19792_ == entity.m_20189_() || entity instanceof Player && !(player = (Player)entity).m_6844_(EquipmentSlot.LEGS).m_41619_())) {
                double d = Math.abs(entity.m_20185_() - entity.f_19790_);
                double e = Math.abs(entity.m_20189_() - entity.f_19792_);
                if (d >= (double)0.003f || e >= (double)0.003f) {
                    entity.m_6469_(DamageSource.f_19325_, 0.5f * (float)(layers - 5));
                }
            }
        }
        if (layers > 0 && level.f_46443_ && entity instanceof LivingEntity && entity.m_146900_().m_60713_((Block)this)) {
            boolean bl;
            RandomSource random = level.m_213780_();
            boolean bl2 = bl = entity.f_19790_ != entity.m_20185_() || entity.f_19792_ != entity.m_20189_();
            if (bl && random.m_188499_()) {
                double y = (double)pos.m_123342_() + SHAPE_BY_LAYER_L[layers].m_83297_(Direction.Axis.Y) + 0.0625;
                int color = Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)level, pos, 0);
                for (Supplier<SimpleParticleType> p : this.particles) {
                    level.m_7106_((ParticleOptions)p.get(), entity.m_20185_() + (double)Mth.m_216283_((RandomSource)random, (float)-0.2f, (float)0.2f), y, entity.m_20189_() + (double)Mth.m_216283_((RandomSource)random, (float)-0.2f, (float)0.2f), (double)Mth.m_216283_((RandomSource)random, (float)-0.75f, (float)-1.0f), (double)color, 0.0);
                }
            }
        }
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        EntityCollisionContext c;
        Entity e;
        if (context instanceof EntityCollisionContext && (e = (c = (EntityCollisionContext)context).m_193113_()) instanceof FallingLayerEntity) {
            return SHAPE_BY_LAYER_L[(Integer)state.m_61143_((Property)LAYERS)];
        }
        return Shapes.m_83040_();
    }

    @Override
    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_LAYER_L[this.getLayers(state)];
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockState bottomState = world.m_8055_(pos.m_7495_());
        if (bottomState.m_60734_() instanceof LeavesBlock) {
            return true;
        }
        if ((Integer)state.m_61143_((Property)LAYERS) != 0 && !bottomState.m_60783_((BlockGetter)world, pos.m_7495_(), Direction.UP)) {
            return false;
        }
        return !this.shouldFall(state, world.m_8055_(pos.m_7495_()));
    }

    @Override
    public boolean shouldFall(BlockState state, BlockState belowState) {
        if ((Integer)state.m_61143_((Property)LAYERS) == 0 && belowState.m_60713_(Blocks.f_49990_) || belowState.m_204336_(ModTags.LEAF_PILES)) {
            return false;
        }
        return super.shouldFall(state, belowState);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && (Integer)state.m_61143_((Property)LAYERS) <= 1) {
            state = (BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(neighborState.m_60713_(Blocks.f_49990_) ? 0 : 1));
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        int i = (Integer)state.m_61143_((Property)LAYERS);
        if (context.m_43722_().m_150930_(this.m_5456_()) && i < 8 && i > 0) {
            return true;
        }
        return i < 3;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = ctx.m_43725_().m_8055_(ctx.m_8083_());
        if (blockState.m_60713_((Block)this)) {
            int i = (Integer)blockState.m_61143_((Property)LAYERS);
            return (BlockState)blockState.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        if (blockState.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
            return null;
        }
        BlockState below = ctx.m_43725_().m_8055_(ctx.m_8083_().m_7495_());
        if (below.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
            if (!blockState.m_60795_()) {
                return null;
            }
            return (BlockState)this.m_49966_().m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(0));
        }
        return super.m_5573_(ctx);
    }

    public boolean m_7370_(BlockGetter world, BlockPos pos, BlockState state, boolean isClient) {
        return this.canBeBonemealed;
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return this.canBeBonemealed;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        for (Direction direction : Direction.values()) {
            if (!(random.m_188501_() > 0.5f)) continue;
            BlockPos targetPos = pos.m_121945_(direction);
            BlockState targetBlock = world.m_8055_(targetPos);
            WeatheringHelper.getAzaleaGrowth(targetBlock).ifPresent(s -> world.m_46597_(targetPos, s));
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockPos blockPos;
        if (random.m_188503_(16) == 0 && LeafPileBlock.m_53241_((BlockState)level.m_8055_(blockPos = pos.m_7495_()))) {
            SimpleParticleType leafParticle = WeatheringHelper.getFallenLeafParticle(state).orElse(null);
            if (leafParticle == null) {
                return;
            }
            int color = Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)level, pos, 0);
            for (Supplier<SimpleParticleType> p : this.particles) {
                if (!((double)random.m_188501_() < 0.2)) continue;
                double d = (double)pos.m_123341_() + random.m_188500_();
                double e = (double)pos.m_123342_() - 0.05;
                double f = (double)pos.m_123343_() + random.m_188500_();
                level.m_7106_((ParticleOptions)leafParticle, d, e, f, 0.0, (double)color, 0.0);
            }
        }
    }

    static {
        Arrays.setAll(SHAPE_BY_LAYER_L, l -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(l * 2), (double)16.0));
        LeafPileBlock.SHAPE_BY_LAYER_L[0] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        COLLISIONS = new float[]{1.0f, 0.999f, 0.998f, 0.997f, 0.996f, 0.994f, 0.993f, 0.992f};
    }
}

