/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.inventory;

import com.mrcrayfish.furniture.refurbished.blockentity.IWorkbench;
import com.mrcrayfish.furniture.refurbished.client.ClientWorkbench;
import com.mrcrayfish.furniture.refurbished.core.ModMenuTypes;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.crafting.WorkbenchContructingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.IElectricityMenu;
import com.mrcrayfish.furniture.refurbished.inventory.SimpleContainerMenu;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class WorkbenchMenu
extends SimpleContainerMenu
implements IElectricityMenu {
    private final IWorkbench workbench;
    private final Level level;
    private final ContainerLevelAccess access;
    private final ContainerData data;
    private final DataSlot selectedRecipe;
    private final DataSlot searchNeighbours;
    private final List<WorkbenchContructingRecipe> recipes;
    private final Map<ResourceLocation, Boolean> recipeToCraftable = new HashMap<ResourceLocation, Boolean>();
    private final ResultContainer result = new ResultContainer();
    private final Slot resultSlot;
    private Map<Integer, Integer> counts = new Int2IntOpenHashMap();
    private long lastSoundTime;
    @Nullable
    private Runnable updateCallback;

    public WorkbenchMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, new ClientWorkbench((Container)new SimpleContainer(12)), (ContainerData)new SimpleContainerData(1));
        this.selectedRecipe.m_6422_(data.m_130242_());
        this.searchNeighbours.m_6422_(data.m_130242_());
        this.data.m_8050_(0, data.m_130242_());
    }

    public WorkbenchMenu(int windowId, Inventory playerInventory, IWorkbench workbench, ContainerData data) {
        super((MenuType)ModMenuTypes.WORKBENCH.get(), windowId, workbench.getWorkbenchContainer());
        WorkbenchMenu.m_38869_((Container)workbench.getWorkbenchContainer(), (int)12);
        WorkbenchMenu.m_38886_((ContainerData)data, (int)1);
        workbench.getWorkbenchContainer().m_5856_(playerInventory.f_35978_);
        this.workbench = workbench;
        this.level = playerInventory.f_35978_.m_9236_();
        this.access = workbench.createLevelAccess();
        this.data = data;
        this.selectedRecipe = workbench.selectedRecipeDataSlot();
        this.searchNeighbours = workbench.searchNeighboursDataSlot();
        this.recipes = this.setupRecipes(this.level);
        this.addContainerSlots(8, 18, 2, 6, 0);
        this.resultSlot = this.m_38897_(new WorkbenchResultSlot((Container)this.result, 0, 188, 21));
        this.addPlayerInventorySlots(28, 147, playerInventory);
        this.m_38895_(this.selectedRecipe);
        this.m_38895_(this.searchNeighbours);
        this.m_38884_(this.data);
    }

    public Level getLevel() {
        return this.level;
    }

    public List<WorkbenchContructingRecipe> getRecipes() {
        return this.recipes;
    }

    private List<WorkbenchContructingRecipe> setupRecipes(Level level) {
        ArrayList<WorkbenchContructingRecipe> recipes = new ArrayList<WorkbenchContructingRecipe>(level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.WORKBENCH_CONSTRUCTING.get()));
        recipes.sort(Comparator.comparing(WorkbenchContructingRecipe::getResultId));
        return recipes;
    }

    private void updateResultSlot() {
        if (!this.level.m_5776_()) {
            int selectedRecipeIndex = this.selectedRecipe.m_6501_();
            if (this.isPowered() && selectedRecipeIndex >= 0 && selectedRecipeIndex < this.recipes.size()) {
                WorkbenchContructingRecipe recipe = this.recipes.get(selectedRecipeIndex);
                if (this.workbench.canCraft(recipe)) {
                    ItemStack output;
                    ItemStack result = this.result.m_8020_(0);
                    if (!ItemStack.m_41728_((ItemStack)result, (ItemStack)(output = recipe.m_8043_()))) {
                        this.resultSlot.m_5852_(output.m_41777_());
                    }
                } else {
                    this.resultSlot.m_5852_(ItemStack.f_41583_);
                }
            } else {
                this.resultSlot.m_5852_(ItemStack.f_41583_);
            }
            super.m_38946_();
        }
    }

    public void m_38946_() {
        this.updateResultSlot();
        super.m_38946_();
    }

    public boolean m_6366_(Player player, int button) {
        if (button >= 0 && button < this.recipes.size()) {
            this.selectedRecipe.m_6422_(button);
            this.updateResultSlot();
            return true;
        }
        return false;
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            stack = slotStack.m_41777_();
            if (slotIndex == this.resultSlot.f_40219_) {
                Item item = slotStack.m_41720_();
                item.m_7836_(slotStack, player.m_9236_(), player);
                if (!this.m_38903_(slotStack, this.container.m_6643_(), this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotStack, stack);
            } else if (slotIndex < this.container.m_6643_() ? !this.m_38903_(slotStack, this.container.m_6643_(), this.f_38839_.size(), true) : (slotIndex < this.container.m_6643_() + 27 ? !this.m_38903_(slotStack, this.container.m_6643_() + 27, this.f_38839_.size(), false) : !this.m_38903_(slotStack, this.container.m_6643_(), this.f_38839_.size() - 9, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
            this.m_38946_();
        }
        return stack;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot != this.resultSlot && super.m_5882_(stack, slot);
    }

    @Override
    public boolean isPowered() {
        return this.data.m_6413_(0) != 0;
    }

    @Nullable
    public WorkbenchContructingRecipe getSelectedRecipe() {
        int index = this.selectedRecipe.m_6501_();
        return index != -1 ? this.recipes.get(index) : null;
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipe.m_6501_();
    }

    public boolean shouldSearchNeighbours() {
        return this.searchNeighbours.m_6501_() != 0;
    }

    public void toggleSearchNeighbours() {
        this.searchNeighbours.m_6422_(this.shouldSearchNeighbours() ? 0 : 1);
        this.m_38946_();
    }

    public void updateItemCounts(Map<Integer, Integer> counts) {
        this.counts = counts;
        this.recipeToCraftable.clear();
        if (this.updateCallback != null) {
            this.updateCallback.run();
        }
    }

    public boolean canCraft(WorkbenchContructingRecipe recipe) {
        return this.isPowered() && this.recipeToCraftable.computeIfAbsent(recipe.m_6423_(), id -> {
            HashMap<Integer, Integer> found = new HashMap<Integer, Integer>();
            for (StackedIngredient material : recipe.getMaterials()) {
                if (this.hasMaterials(material, found)) continue;
                return false;
            }
            return true;
        }) != false;
    }

    public boolean hasMaterials(StackedIngredient material, Map<Integer, Integer> counted) {
        int remaining = material.count();
        for (ItemStack stack : material.ingredient().m_43908_()) {
            int itemId = Item.m_41393_((Item)stack.m_41720_());
            int count = this.counts.getOrDefault(itemId, 0);
            if ((count -= counted.getOrDefault(itemId, 0).intValue()) <= 0) continue;
            if (count >= remaining) {
                counted.merge(itemId, remaining, Integer::sum);
                remaining = 0;
                break;
            }
            counted.merge(itemId, count, Integer::sum);
            remaining -= count;
        }
        return remaining <= 0;
    }

    public void setUpdateCallback(Runnable callback) {
        this.updateCallback = callback;
    }

    private void onCraft() {
        WorkbenchContructingRecipe recipe = this.getSelectedRecipe();
        if (recipe != null && this.workbench.canCraft(recipe)) {
            this.workbench.performCraft(recipe);
            this.updateResultSlot();
            this.access.m_39292_((level, pos) -> {
                long time = level.m_46467_();
                this.lastSoundTime = time;
                if (this.lastSoundTime != this.lastSoundTime) {
                    level.m_5594_(null, pos, (SoundEvent)ModSounds.BLOCK_WORKBENCH_CRAFT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            });
        }
    }

    private class WorkbenchResultSlot
    extends Slot {
        public WorkbenchResultSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public void m_142406_(Player player, ItemStack stack) {
            stack.m_41678_(player.m_9236_(), player, stack.m_41613_());
            WorkbenchMenu.this.onCraft();
            super.m_142406_(player, stack);
        }
    }
}

