/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer.client.graphics;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.client.util.AudioHelper;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.computer.app.PaddleBall;
import com.mrcrayfish.furniture.refurbished.computer.client.DisplayableProgram;
import com.mrcrayfish.furniture.refurbished.computer.client.Scene;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerButton;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessagePaddleBall;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public class PaddleBallGraphics
extends DisplayableProgram<PaddleBall> {
    private static final ResourceLocation TEXTURE = Utils.resource("textures/gui/program/paddle_ball.png");
    private float ballX;
    private float lastBallX;
    private float ballY;
    private float lastBallY;
    private float ballVelocityX;
    private float ballVelocityY;
    private float playerPos;
    private float lastPlayerPos;
    private float targetPlayerPos;
    private float opponentPos;
    private float lastOpponentPos;
    private float targetOpponentPos;
    private int playerScore;
    private int opponentScore;
    private int scoreSide;
    private int scoreAnimation;
    @Nullable
    private Component displayLabel;
    private Boolean wonGame;
    private boolean playing;
    private boolean leftPaddle;
    private String opponentName = "Opponent";

    public PaddleBallGraphics(PaddleBall program) {
        super(program, 200, 100);
        this.setScene(new MainMenuScene(this));
    }

    @Override
    public void tick() {
        this.lastBallX = this.ballX;
        this.lastBallY = this.ballY;
        this.lastPlayerPos = this.playerPos;
        this.lastOpponentPos = this.opponentPos;
        this.ballX += this.ballVelocityX;
        this.ballY += this.ballVelocityY;
        this.playerPos = this.targetPlayerPos;
        this.opponentPos = this.targetOpponentPos;
        super.tick();
    }

    @Override
    public boolean blocksNavigation() {
        return this.playing;
    }

    public void updatePaddles(float playerPos, float opponentPos) {
        this.targetPlayerPos = this.leftPaddle ? playerPos : opponentPos;
        this.targetOpponentPos = this.leftPaddle ? opponentPos : playerPos;
    }

    public void updateBall(float ballX, float ballY, float velocityX, float velocityY) {
        this.ballX = ballX;
        this.ballY = ballY;
        this.ballVelocityX = velocityX;
        this.ballVelocityY = velocityY;
    }

    public void handleOpponentName(String name) {
        this.opponentName = name;
    }

    public void handleEvent(byte event) {
        switch (event) {
            case 1: {
                this.reset();
                this.playing = true;
                this.setScene(new GameScene(this));
                break;
            }
            case 2: {
                this.leftPaddle = true;
                break;
            }
            case 3: {
                this.leftPaddle = false;
                break;
            }
            case 4: {
                AudioHelper.playUISound((SoundEvent)ModSounds.UI_PADDLE_BALL_RETRO_WIN.get(), 1.0f, 0.5f);
                this.displayLabel = this.translation("win_game");
                this.wonGame = true;
                this.playing = false;
                break;
            }
            case 5: {
                AudioHelper.playUISound((SoundEvent)ModSounds.UI_PADDLE_BALL_RETRO_LOSE.get(), 1.0f, 0.5f);
                this.displayLabel = this.translation("lose_game");
                this.wonGame = false;
                this.playing = false;
                break;
            }
            case 6: {
                ++this.playerScore;
                this.scoreSide = 1;
                this.scoreAnimation = 40;
                if (this.playerScore >= 7) break;
                AudioHelper.playUISound((SoundEvent)ModSounds.UI_PADDLE_BALL_RETRO_SUCCESS.get(), 1.0f, 0.5f);
                break;
            }
            case 7: {
                ++this.opponentScore;
                this.scoreSide = 0;
                this.scoreAnimation = 40;
                if (this.opponentScore >= 7) break;
                AudioHelper.playUISound((SoundEvent)ModSounds.UI_PADDLE_BALL_RETRO_FAIL.get(), 1.0f, 0.5f);
                break;
            }
            case 8: {
                this.displayLabel = this.translation("opponent_left");
                this.wonGame = false;
                break;
            }
            case 40: {
                AudioHelper.playUISound((SoundEvent)ModSounds.UI_PADDLE_BALL_RETRO_HIT.get(), 1.0f, 0.5f);
            }
        }
    }

    private void reset() {
        this.displayLabel = null;
        this.wonGame = null;
        this.playerScore = 0;
        this.opponentScore = 0;
        this.ballVelocityX = 0.0f;
        this.ballVelocityY = 0.0f;
        this.scoreAnimation = 0;
        this.opponentName = "Opponent";
    }

    private static class MainMenuScene
    extends Scene {
        private final PaddleBallGraphics game;
        private final MenuButton playAiButton;
        private final MenuButton playVsButton;

        public MainMenuScene(PaddleBallGraphics game) {
            this.game = game;
            this.playAiButton = this.addWidget(new MenuButton(100, 16, this.game.translation("play_ai"), btn -> Network.getPlay().sendToServer((IMessage)new MessagePaddleBall.Action(PaddleBall.Action.JOIN_GAME, 0))));
            this.playAiButton.setClickSound((SoundEvent)ModSounds.UI_PADDLE_BALL_RETRO_CLICK.get());
            this.playVsButton = this.addWidget(new MenuButton(100, 16, this.game.translation("play_vs"), btn -> {
                Network.getPlay().sendToServer((IMessage)new MessagePaddleBall.Action(PaddleBall.Action.JOIN_GAME, 1));
                game.setScene(new PendingScene(game));
            }));
            this.playVsButton.setClickSound((SoundEvent)ModSounds.UI_PADDLE_BALL_RETRO_CLICK.get());
            Minecraft mc = Minecraft.m_91087_();
            if ((mc.m_91092_() == null || mc.m_91091_()) && mc.m_91089_() == null) {
                this.playVsButton.f_93623_ = false;
            }
            game.playing = false;
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
            this.playAiButton.f_93620_ = contentStart + (this.game.width - this.playAiButton.m_5711_()) / 2;
            this.playAiButton.f_93621_ = contentTop + 45;
            this.playVsButton.f_93620_ = contentStart + (this.game.width - this.playVsButton.m_5711_()) / 2;
            this.playVsButton.f_93621_ = contentTop + 65;
        }

        @Override
        public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            Minecraft mc;
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            this.playAiButton.m_93228_(poseStack, (this.game.width - 128) / 2, 10, 16, 0, 128, 24);
            if (this.playAiButton.m_198029_() && ((mc = Minecraft.m_91087_()).m_91092_() == null || mc.m_91091_()) && mc.m_91089_() == null && mc.f_91080_ != null) {
                mc.f_91080_.m_96602_(poseStack, this.game.translation("server_required"), mouseX, mouseY);
            }
        }

        private static class MenuButton
        extends ComputerButton {
            public MenuButton(int width, int height, Component label, Button.OnPress onPress) {
                super(width, height, label, onPress);
            }

            @Override
            public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
                super.m_6303_(poseStack, mouseX, mouseY, partialTick);
                if (this.m_142518_() && this.m_198029_()) {
                    RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
                    this.m_93228_(poseStack, this.f_93620_ - 6, this.f_93621_ + 6, 12, 0, 4, 4);
                    this.m_93228_(poseStack, this.f_93620_ + this.m_5711_() + 2, this.f_93621_ + 6, 12, 0, 4, 4);
                }
            }
        }
    }

    private static class GameScene
    extends Scene {
        private final PaddleBallGraphics game;
        private final MainMenuScene.MenuButton backButton;

        public GameScene(PaddleBallGraphics game) {
            this.game = game;
            this.backButton = this.addWidget(new MainMenuScene.MenuButton(100, 16, this.game.translation("main_menu"), btn -> game.setScene(new MainMenuScene(game))));
            this.backButton.setBackgroundHighlightColour(-12107714);
            this.backButton.setTextHighlightColour(-14540251);
            this.backButton.setClickSound((SoundEvent)ModSounds.UI_PADDLE_BALL_RETRO_CLICK.get());
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
            this.backButton.f_93620_ = contentStart + (this.game.width - this.backButton.m_5711_()) / 2;
            this.backButton.f_93621_ = contentTop + 60;
        }

        @Override
        public void tick() {
            this.sendInputToServer();
            if (this.game.scoreAnimation > 0) {
                --this.game.scoreAnimation;
            }
        }

        @Override
        public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            this.backButton.f_93623_ = this.game.wonGame != null;
            this.backButton.f_93624_ = this.game.wonGame != null;
            Minecraft mc = Minecraft.m_91087_();
            poseStack.m_85836_();
            poseStack.m_85837_(100.0, 4.0, 0.0);
            poseStack.m_85836_();
            String label = Integer.toString(this.game.playerScore);
            int width = mc.f_91062_.m_92895_(label) * 2;
            poseStack.m_85837_((double)(-width - 7), 0.0, 0.0);
            poseStack.m_85841_(2.0f, 2.0f, 2.0f);
            ScreenHelper.drawString(poseStack, label, 0, 0, -13684941, false);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85841_(2.0f, 2.0f, 2.0f);
            int breakWidth = mc.f_91062_.m_92895_(label) / 2;
            ScreenHelper.drawString(poseStack, "-", -breakWidth, 0, -13684941, false);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85837_(7.0, 0.0, 0.0);
            poseStack.m_85841_(2.0f, 2.0f, 2.0f);
            ScreenHelper.drawString(poseStack, Integer.toString(this.game.opponentScore), 0, 0, -13684941, false);
            poseStack.m_85849_();
            poseStack.m_85849_();
            ScreenHelper.drawString(poseStack, this.game.translation("you"), 5, 5, -13684941, false);
            String opponentName = this.game.opponentName;
            ScreenHelper.drawString(poseStack, opponentName, 195 - mc.f_91062_.m_92895_(opponentName), 5, -13684941, false);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            poseStack.m_85836_();
            float smoothHostPos = Mth.m_14179_((float)partialTick, (float)this.game.lastPlayerPos, (float)this.game.playerPos);
            poseStack.m_85837_(4.0, (double)smoothHostPos, 0.0);
            this.backButton.m_93228_(poseStack, 0, 0, 0, 0, 6, 28);
            poseStack.m_85849_();
            poseStack.m_85836_();
            float smoothOpponentPos = Mth.m_14179_((float)partialTick, (float)this.game.lastOpponentPos, (float)this.game.opponentPos);
            poseStack.m_85837_(192.0, (double)smoothOpponentPos, 0.0);
            this.backButton.m_93228_(poseStack, -2, 0, 6, 0, 6, 28);
            poseStack.m_85849_();
            poseStack.m_85836_();
            float smoothBallX = Mth.m_14179_((float)partialTick, (float)this.game.lastBallX, (float)this.game.ballX);
            float smoothBallY = Mth.m_14179_((float)partialTick, (float)this.game.lastBallY, (float)this.game.ballY);
            smoothBallX = this.game.leftPaddle ? smoothBallX : 200.0f - smoothBallX;
            poseStack.m_85837_((double)smoothBallX, (double)smoothBallY, 0.0);
            this.backButton.m_93228_(poseStack, 0, 0, 12, 0, 4, 4);
            poseStack.m_85849_();
            if (this.game.scoreAnimation > 0 && this.game.scoreAnimation / 5 % 2 == 0) {
                poseStack.m_85836_();
                poseStack.m_85837_((double)(196 * this.game.scoreSide), 0.0, 0.0);
                GuiComponent.m_93172_((PoseStack)poseStack, (int)0, (int)0, (int)4, (int)100, (int)-10143432);
                poseStack.m_85849_();
            }
            if (this.game.wonGame != null && this.game.displayLabel != null) {
                Component bannerLabel = this.game.displayLabel;
                int bannerColour = this.game.wonGame != false ? -13147337 : -10143432;
                GuiComponent.m_93215_((PoseStack)poseStack, (Font)mc.f_91062_, (Component)bannerLabel, (int)(this.game.width / 2), (int)40, (int)bannerColour);
            }
        }

        private void sendInputToServer() {
            boolean up = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)265);
            boolean down = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)264);
            byte input = (byte)(up && down ? 0 : (up ? 1 : (down ? 2 : 0)));
            Network.getPlay().sendToServer((IMessage)new MessagePaddleBall.Action(PaddleBall.Action.INPUT, input));
        }
    }

    private static class PendingScene
    extends Scene {
        private final PaddleBallGraphics game;
        private final MainMenuScene.MenuButton backButton;

        private PendingScene(PaddleBallGraphics game) {
            this.game = game;
            this.backButton = this.addWidget(new MainMenuScene.MenuButton(100, 16, this.game.translation("cancel"), btn -> {
                Network.getPlay().sendToServer((IMessage)new MessagePaddleBall.Action(PaddleBall.Action.UPDATE_STATE, 0));
                game.setScene(new MainMenuScene(game));
            }));
            this.backButton.setClickSound((SoundEvent)ModSounds.UI_PADDLE_BALL_RETRO_CLICK.get());
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
            this.backButton.f_93620_ = contentStart + (this.game.width - this.backButton.m_5711_()) / 2;
            this.backButton.f_93621_ = contentTop + 65;
        }

        @Override
        public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            this.backButton.m_93228_(poseStack, (this.game.width - 128) / 2, 10, 16, 0, 128, 24);
            String loading = switch ((int)(Util.m_137550_() / 300L % 4L)) {
                default -> "O o o";
                case 1, 3 -> "o O o";
                case 2 -> "o o O";
            };
            Minecraft mc = Minecraft.m_91087_();
            GuiComponent.m_93208_((PoseStack)poseStack, (Font)mc.f_91062_, (String)loading, (int)(this.game.width / 2), (int)50, (int)-2896706);
            GuiComponent.m_93215_((PoseStack)poseStack, (Font)mc.f_91062_, (Component)this.game.translation("searching_players"), (int)(this.game.width / 2), (int)40, (int)-2896706);
        }
    }
}

