/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.function.Function;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TextInputScreen
extends Screen {
    public static final ResourceLocation TEXT_INPUT_TEXTURE = Utils.resource("textures/gui/text_input.png");
    public static final int WINDOW_WIDTH = 160;
    public static final int WINDOW_HEIGHT = 72;
    protected final Component hint;
    protected final Function<String, Boolean> callback;
    protected Function<String, Boolean> validator = s -> true;
    protected EditBox editBox;
    protected Button closeButton;
    protected Button acceptButton;
    protected Component acceptLabel;
    protected String input = "";

    public TextInputScreen(Component title, Component hint, Function<String, Boolean> callback) {
        super(title);
        this.hint = hint;
        this.callback = callback;
    }

    public void setValidator(Function<String, Boolean> validator) {
        this.validator = validator;
    }

    public void setAcceptLabel(Component acceptLabel) {
        this.acceptLabel = acceptLabel;
    }

    protected void m_7856_() {
        int startX = (this.f_96543_ - 160) / 2;
        int startY = (this.f_96544_ - 72) / 2;
        this.editBox = new EditBox(this.f_96541_.f_91062_, startX + 6, startY + 20, 148, 20, this.hint);
        this.m_142416_((GuiEventListener)this.editBox);
        this.editBox.m_94151_(this::updateAcceptButton);
        if (!this.input.isBlank()) {
            this.editBox.m_94144_(this.input);
        }
        this.closeButton = new Button(startX + 6, startY + 45, 72, 20, (Component)Component.m_237113_((String)"Close"), btn -> this.f_96541_.m_91152_(null));
        this.m_142416_((GuiEventListener)this.closeButton);
        this.acceptButton = new Button(startX + 74 + 2 + 6, startY + 45, 72, 20, (Component)MoreObjects.firstNonNull((Object)this.acceptLabel, (Object)Component.m_237113_((String)"Accept")), btn -> {
            if (this.callback.apply(this.input).booleanValue()) {
                this.f_96541_.m_91152_(null);
            }
        });
        this.m_142416_((GuiEventListener)this.acceptButton);
        this.updateAcceptButton(this.input);
    }

    private void updateAcceptButton(String input) {
        boolean valid = this.validator.apply(input);
        this.editBox.m_94202_(valid ? 0xFFFFFF : 0xFF0000);
        this.acceptButton.f_93623_ = valid;
        this.input = input;
    }

    public void m_86600_() {
        this.editBox.m_94120_();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        int startX = (this.f_96543_ - 160) / 2;
        int startY = (this.f_96544_ - 72) / 2;
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXT_INPUT_TEXTURE);
        this.m_93228_(poseStack, startX, startY, 0, 0, 160, 72);
        ScreenHelper.drawString(poseStack, this.f_96539_, startX + 6, startY + 7, 0x404040, false);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

